/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.discovery;

import com.hazelcast.spi.properties.GroupProperty;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.causalclustering.discovery.CoreTopologyService;
import org.neo4j.causalclustering.discovery.DiscoveryServiceFactory;
import org.neo4j.causalclustering.discovery.HazelcastClient;
import org.neo4j.causalclustering.discovery.HazelcastClientConnector;
import org.neo4j.causalclustering.discovery.HazelcastCoreTopologyService;
import org.neo4j.causalclustering.discovery.HostnameResolver;
import org.neo4j.causalclustering.discovery.TopologyService;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.util.JobScheduler;
import org.neo4j.logging.LogProvider;
import org.neo4j.ssl.SslPolicy;

public class HazelcastDiscoveryServiceFactory
implements DiscoveryServiceFactory {
    @Override
    public CoreTopologyService coreTopologyService(Config config, SslPolicy sslPolicy, MemberId myself, JobScheduler jobScheduler, LogProvider logProvider, LogProvider userLogProvider, HostnameResolver hostnameResolver) {
        HazelcastDiscoveryServiceFactory.configureHazelcast(config);
        return new HazelcastCoreTopologyService(config, sslPolicy, myself, jobScheduler, logProvider, userLogProvider, hostnameResolver);
    }

    @Override
    public TopologyService topologyService(Config config, SslPolicy sslPolicy, LogProvider logProvider, JobScheduler jobScheduler, MemberId myself, HostnameResolver hostnameResolver) {
        HazelcastDiscoveryServiceFactory.configureHazelcast(config);
        return new HazelcastClient(new HazelcastClientConnector(config, logProvider, sslPolicy, hostnameResolver), jobScheduler, logProvider, config, myself);
    }

    private static void configureHazelcast(Config config) {
        System.setProperty("hazelcast.phone.home.enabled", "false");
        System.setProperty("hazelcast.socket.server.bind.any", "false");
        String licenseKey = (String)config.get(CausalClusteringSettings.hazelcast_license_key);
        if (licenseKey != null) {
            GroupProperty.ENTERPRISE_LICENSE_KEY.setSystemProperty(licenseKey);
        }
        if (((Boolean)config.get(CausalClusteringSettings.disable_middleware_logging)).booleanValue()) {
            System.setProperty("hazelcast.logging.type", "none");
        }
    }
}

