/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.discovery;

import com.hazelcast.nio.ssl.SSLContextFactory;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.util.Properties;
import java.util.UUID;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.ssl.SslPolicy;

class HazelcastSslContextFactory
implements SSLContextFactory {
    private static final String PROTOCOL = "TLS";
    private final SslPolicy sslPolicy;
    private final Log log;

    HazelcastSslContextFactory(SslPolicy sslPolicy, LogProvider logProvider) {
        this.sslPolicy = sslPolicy;
        this.log = logProvider.getLog(this.getClass());
    }

    public void init(Properties properties) throws Exception {
    }

    public SSLContext getSSLContext() {
        KeyManagerFactory keyManagerFactory;
        SSLContext sslCtx;
        try {
            sslCtx = SSLContext.getInstance(PROTOCOL);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        try {
            keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        String password = UUID.randomUUID().toString();
        KeyStore keyStore = this.sslPolicy.getKeyStore(password.toCharArray(), password.toCharArray());
        try {
            keyManagerFactory.init(keyStore, password.toCharArray());
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
            throw new RuntimeException(e);
        }
        KeyManager[] keyManagers = keyManagerFactory.getKeyManagers();
        TrustManager[] trustManagers = this.sslPolicy.getTrustManagerFactory().getTrustManagers();
        try {
            sslCtx.init(keyManagers, trustManagers, null);
        }
        catch (KeyManagementException e) {
            throw new RuntimeException(e);
        }
        if (this.sslPolicy.getTlsVersions() != null) {
            this.log.warn(String.format("Restricting TLS versions through policy not supported. System defaults for %s family will be used.", PROTOCOL));
        }
        if (this.sslPolicy.getCipherSuites() != null) {
            this.log.warn("Restricting ciphers through policy not supported. System defaults will be used.");
        }
        return sslCtx;
    }
}

