/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.discovery;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.neo4j.causalclustering.discovery.Difference;
import org.neo4j.causalclustering.discovery.ReadReplicaInfo;
import org.neo4j.causalclustering.discovery.TopologyDifference;
import org.neo4j.causalclustering.identity.MemberId;

public class ReadReplicaTopology {
    static final ReadReplicaTopology EMPTY = new ReadReplicaTopology(Collections.emptyMap());
    private final Map<MemberId, ReadReplicaInfo> readReplicaMembers;

    public ReadReplicaTopology(Map<MemberId, ReadReplicaInfo> readReplicaMembers) {
        this.readReplicaMembers = readReplicaMembers;
    }

    public Collection<ReadReplicaInfo> allMemberInfo() {
        return this.readReplicaMembers.values();
    }

    public Map<MemberId, ReadReplicaInfo> members() {
        return this.readReplicaMembers;
    }

    Optional<ReadReplicaInfo> find(MemberId memberId) {
        return Optional.ofNullable(this.readReplicaMembers.get(memberId));
    }

    public String toString() {
        return String.format("{readReplicas=%s}", this.readReplicaMembers);
    }

    public Optional<MemberId> anyReadReplicaMemberId() {
        if (this.readReplicaMembers.keySet().size() == 0) {
            return Optional.empty();
        }
        return this.readReplicaMembers.keySet().stream().findAny();
    }

    TopologyDifference difference(ReadReplicaTopology other) {
        Set<MemberId> members = this.readReplicaMembers.keySet();
        Set<MemberId> otherMembers = other.readReplicaMembers.keySet();
        Set<Difference> added = otherMembers.stream().filter(m -> !members.contains(m)).map(memberId -> Difference.asDifference(other, memberId)).collect(Collectors.toSet());
        Set<Difference> removed = members.stream().filter(m -> !otherMembers.contains(m)).map(memberId -> Difference.asDifference(this, memberId)).collect(Collectors.toSet());
        return new TopologyDifference(added, removed);
    }
}

