/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.helper;

import java.util.concurrent.TimeoutException;
import java.util.function.Predicate;

public class VolatileFuture<T> {
    private volatile T value;

    public VolatileFuture(T initialValue) {
        this.value = initialValue;
    }

    public synchronized void set(T value) {
        if (this.value != value) {
            this.value = value;
            this.notifyAll();
        }
    }

    public T get(long timeoutMillis, Predicate<T> predicate) throws TimeoutException, InterruptedException {
        T alias = this.value;
        if (predicate.test(alias)) {
            return alias;
        }
        if (timeoutMillis == 0L) {
            throw new TimeoutException();
        }
        return this.waitForValue(timeoutMillis + System.currentTimeMillis(), predicate);
    }

    private synchronized T waitForValue(long endTimeMillis, Predicate<T> predicate) throws InterruptedException, TimeoutException {
        T alias;
        while (!predicate.test(alias = this.value)) {
            long timeLeft = endTimeMillis - System.currentTimeMillis();
            if (timeLeft > 0L) {
                this.wait(timeLeft);
                continue;
            }
            throw new TimeoutException();
        }
        return alias;
    }
}

