/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.load_balancing;

import java.util.Objects;
import org.neo4j.causalclustering.load_balancing.Role;
import org.neo4j.helpers.AdvertisedSocketAddress;

public class Endpoint {
    private final AdvertisedSocketAddress address;
    private final Role role;

    public Endpoint(AdvertisedSocketAddress address, Role role) {
        this.address = address;
        this.role = role;
    }

    public AdvertisedSocketAddress address() {
        return this.address;
    }

    public static Endpoint write(AdvertisedSocketAddress address) {
        return new Endpoint(address, Role.WRITE);
    }

    public static Endpoint read(AdvertisedSocketAddress address) {
        return new Endpoint(address, Role.READ);
    }

    public static Endpoint route(AdvertisedSocketAddress address) {
        return new Endpoint(address, Role.ROUTE);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Endpoint endPoint = (Endpoint)o;
        return Objects.equals(this.address, endPoint.address) && this.role == endPoint.role;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.address, this.role});
    }

    public String toString() {
        return "EndPoint{address=" + this.address + ", role=" + (Object)((Object)this.role) + '}';
    }
}

