/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.load_balancing.plugins.server_policies;

import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.causalclustering.core.consensus.LeaderLocator;
import org.neo4j.causalclustering.core.consensus.NoLeaderFoundException;
import org.neo4j.causalclustering.discovery.CoreServerInfo;
import org.neo4j.causalclustering.discovery.CoreTopology;
import org.neo4j.causalclustering.discovery.ReadReplicaInfo;
import org.neo4j.causalclustering.discovery.ReadReplicaTopology;
import org.neo4j.causalclustering.discovery.TopologyService;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.load_balancing.Endpoint;
import org.neo4j.causalclustering.load_balancing.LoadBalancingPlugin;
import org.neo4j.causalclustering.load_balancing.LoadBalancingProcessor;
import org.neo4j.causalclustering.load_balancing.LoadBalancingResult;
import org.neo4j.causalclustering.load_balancing.Util;
import org.neo4j.causalclustering.load_balancing.plugins.server_policies.FilteringPolicyLoader;
import org.neo4j.causalclustering.load_balancing.plugins.server_policies.InvalidFilterSpecification;
import org.neo4j.causalclustering.load_balancing.plugins.server_policies.Policies;
import org.neo4j.causalclustering.load_balancing.plugins.server_policies.Policy;
import org.neo4j.causalclustering.load_balancing.plugins.server_policies.ServerInfo;
import org.neo4j.graphdb.config.InvalidSettingException;
import org.neo4j.kernel.api.exceptions.ProcedureException;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

public class ServerPoliciesPlugin
implements LoadBalancingPlugin {
    public static final String PLUGIN_NAME = "server_policies";
    private TopologyService topologyService;
    private LeaderLocator leaderLocator;
    private Long timeToLive;
    private boolean allowReadsOnFollowers;
    private Policies policies;

    @Override
    public void validate(Config config, Log log) throws InvalidSettingException {
        try {
            FilteringPolicyLoader.load(config, PLUGIN_NAME, log);
        }
        catch (InvalidFilterSpecification e) {
            throw new InvalidSettingException("Invalid filter specification", (Throwable)e);
        }
    }

    @Override
    public void init(TopologyService topologyService, LeaderLocator leaderLocator, LogProvider logProvider, Config config) throws InvalidFilterSpecification {
        this.topologyService = topologyService;
        this.leaderLocator = leaderLocator;
        this.timeToLive = ((Duration)config.get(CausalClusteringSettings.cluster_routing_ttl)).toMillis();
        this.allowReadsOnFollowers = (Boolean)config.get(CausalClusteringSettings.cluster_allow_reads_on_followers);
        this.policies = FilteringPolicyLoader.load(config, PLUGIN_NAME, logProvider.getLog(this.getClass()));
    }

    @Override
    public String pluginName() {
        return PLUGIN_NAME;
    }

    @Override
    public LoadBalancingProcessor.Result run(Map<String, String> context) throws ProcedureException {
        Policy policy = this.policies.selectFor(context);
        CoreTopology coreTopology = this.topologyService.coreServers();
        ReadReplicaTopology rrTopology = this.topologyService.readReplicas();
        return new LoadBalancingResult(this.routeEndpoints(coreTopology), this.writeEndpoints(coreTopology), this.readEndpoints(coreTopology, rrTopology, policy), this.timeToLive);
    }

    private List<Endpoint> routeEndpoints(CoreTopology cores) {
        return cores.members().values().stream().map(Util.extractBoltAddress()).map(Endpoint::route).collect(Collectors.toList());
    }

    private List<Endpoint> writeEndpoints(CoreTopology cores) {
        MemberId leader;
        try {
            leader = this.leaderLocator.getLeader();
        }
        catch (NoLeaderFoundException e) {
            return Collections.emptyList();
        }
        Optional<Endpoint> endPoint = cores.find(leader).map(Util.extractBoltAddress()).map(Endpoint::write);
        return Util.asList(endPoint);
    }

    private List<Endpoint> readEndpoints(CoreTopology coreTopology, ReadReplicaTopology rrTopology, Policy policy) {
        Set<ServerInfo> possibleReaders = rrTopology.members().entrySet().stream().map(entry -> new ServerInfo(((ReadReplicaInfo)entry.getValue()).connectors().boltAddress(), (MemberId)entry.getKey(), ((ReadReplicaInfo)entry.getValue()).groups())).collect(Collectors.toSet());
        if (this.allowReadsOnFollowers || possibleReaders.size() == 0) {
            Set<MemberId> validCores = coreTopology.members().keySet();
            try {
                MemberId leader = this.leaderLocator.getLeader();
                validCores = validCores.stream().filter(memberId -> !memberId.equals(leader)).collect(Collectors.toSet());
            }
            catch (NoLeaderFoundException noLeaderFoundException) {
                // empty catch block
            }
            for (MemberId validCore : validCores) {
                Optional<CoreServerInfo> coreServerInfo = coreTopology.find(validCore);
                if (!coreServerInfo.isPresent()) continue;
                CoreServerInfo serverInfo = coreServerInfo.get();
                possibleReaders.add(new ServerInfo(serverInfo.connectors().boltAddress(), validCore, serverInfo.groups()));
            }
        }
        Set<ServerInfo> readers = policy.apply(possibleReaders);
        return readers.stream().map(r -> Endpoint.read(r.boltAddress())).collect(Collectors.toList());
    }
}

