/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.load_balancing.procedure;

import java.util.Arrays;

public enum ProcedureNames {
    GET_SERVERS_V1("getServers"),
    GET_SERVERS_V2("getRoutingTable");

    private static final String[] nameSpace;
    private final String name;

    private ProcedureNames(String name) {
        this.name = name;
    }

    public String procedureName() {
        return this.name;
    }

    public String[] procedureNameSpace() {
        return nameSpace;
    }

    public String[] fullyQualifiedProcedureName() {
        String[] fullyQualifiedProcedureName = Arrays.copyOf(nameSpace, nameSpace.length + 1);
        fullyQualifiedProcedureName[ProcedureNames.nameSpace.length] = this.name;
        return fullyQualifiedProcedureName;
    }

    public String callName() {
        return String.join((CharSequence)".", nameSpace) + "." + this.name;
    }

    static {
        nameSpace = new String[]{"dbms", "cluster", "routing"};
    }
}

