/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.logging;

import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.neo4j.causalclustering.logging.MessageLogger;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;

public class BetterMessageLogger<MEMBER>
extends LifecycleAdapter
implements MessageLogger<MEMBER> {
    private final PrintWriter printWriter;
    private DateFormat dateFormat = new SimpleDateFormat("HH:mm:ss.SSS");

    public BetterMessageLogger(MEMBER myself, PrintWriter printWriter) {
        this.printWriter = printWriter;
        printWriter.println("I am " + myself);
        printWriter.flush();
    }

    private void log(MEMBER from, MEMBER to, Object message) {
        this.printWriter.println(String.format("%s -->%s: %s: %s", this.dateFormat.format(new Date()), to, message.getClass().getSimpleName(), String.valueOf(message)));
        this.printWriter.flush();
    }

    @Override
    public void log(MEMBER from, MEMBER to, Object ... messages) {
        for (Object message : messages) {
            this.log(from, to, message);
        }
    }

    @Override
    public void log(MEMBER to, Object message) {
        this.printWriter.println(String.format("%s <--%s: %s", this.dateFormat.format(new Date()), message.getClass().getSimpleName(), String.valueOf(message)));
        this.printWriter.flush();
    }

    public void stop() {
        this.printWriter.close();
    }
}

