/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.messaging;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.LengthFieldPrepender;
import org.neo4j.causalclustering.VersionPrepender;
import org.neo4j.causalclustering.core.replication.ReplicatedContent;
import org.neo4j.causalclustering.handlers.ExceptionLoggingHandler;
import org.neo4j.causalclustering.handlers.ExceptionMonitoringHandler;
import org.neo4j.causalclustering.handlers.ExceptionSwallowingHandler;
import org.neo4j.causalclustering.messaging.SenderService;
import org.neo4j.causalclustering.messaging.marshalling.ChannelMarshal;
import org.neo4j.causalclustering.messaging.marshalling.RaftMessageEncoder;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.ssl.SslPolicy;

public class RaftChannelInitializer
extends ChannelInitializer<SocketChannel> {
    private final ChannelMarshal<ReplicatedContent> marshal;
    private final Log log;
    private final Monitors monitors;
    private final SslPolicy sslPolicy;

    public RaftChannelInitializer(ChannelMarshal<ReplicatedContent> marshal, LogProvider logProvider, Monitors monitors, SslPolicy sslPolicy) {
        this.marshal = marshal;
        this.log = logProvider.getLog(((Object)((Object)this)).getClass());
        this.monitors = monitors;
        this.sslPolicy = sslPolicy;
    }

    protected void initChannel(SocketChannel ch) throws Exception {
        ChannelPipeline pipeline = ch.pipeline();
        if (this.sslPolicy != null) {
            pipeline.addLast(new ChannelHandler[]{this.sslPolicy.nettyClientHandler((Channel)ch)});
        }
        pipeline.addLast("frameEncoder", (ChannelHandler)new LengthFieldPrepender(4));
        pipeline.addLast(new ChannelHandler[]{new VersionPrepender()});
        pipeline.addLast("raftMessageEncoder", (ChannelHandler)new RaftMessageEncoder(this.marshal));
        pipeline.addLast(new ChannelHandler[]{new ExceptionLoggingHandler(this.log)});
        pipeline.addLast(new ChannelHandler[]{new ExceptionMonitoringHandler((ExceptionMonitoringHandler.Monitor)this.monitors.newMonitor(ExceptionMonitoringHandler.Monitor.class, SenderService.class, new String[0]))});
        pipeline.addLast(new ChannelHandler[]{new ExceptionSwallowingHandler()});
    }
}

