/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.readreplica;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.causalclustering.discovery.ReadReplicaInfo;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.readreplica.UpstreamDatabaseSelectionException;
import org.neo4j.causalclustering.readreplica.UpstreamDatabaseSelectionStrategy;

public class ConnectRandomlyWithinServerGroupStrategy
extends UpstreamDatabaseSelectionStrategy {
    private Random random = new Random();

    public ConnectRandomlyWithinServerGroupStrategy() {
        super("connect-randomly-within-server-group", new String[0]);
    }

    @Override
    public Optional<MemberId> upstreamDatabase() throws UpstreamDatabaseSelectionException {
        Map<MemberId, ReadReplicaInfo> replicas = this.topologyService.readReplicas().members();
        List groups = (List)this.config.get(CausalClusteringSettings.server_groups);
        if (groups.isEmpty()) {
            return Optional.empty();
        }
        ArrayList choices = new ArrayList();
        for (String group : groups) {
            List list = replicas.entrySet().stream().filter(entry -> ((ReadReplicaInfo)entry.getValue()).groups().contains(group) && !((MemberId)entry.getKey()).equals(this.myself)).collect(Collectors.toList());
            choices.addAll(list);
        }
        if (choices.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(((Map.Entry)choices.get(this.random.nextInt(choices.size()))).getKey());
    }
}

