/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.readreplica;

import java.io.IOException;
import org.neo4j.causalclustering.catchup.storecopy.LocalDatabase;
import org.neo4j.causalclustering.catchup.storecopy.RemoteStore;
import org.neo4j.causalclustering.catchup.storecopy.StoreCopyFailedException;
import org.neo4j.causalclustering.catchup.storecopy.StoreCopyProcess;
import org.neo4j.causalclustering.catchup.storecopy.StoreIdDownloadFailedException;
import org.neo4j.causalclustering.catchup.storecopy.StreamingTransactionsFailedException;
import org.neo4j.causalclustering.helper.RetryStrategy;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.identity.StoreId;
import org.neo4j.causalclustering.readreplica.UpstreamDatabaseSelectionException;
import org.neo4j.causalclustering.readreplica.UpstreamDatabaseStrategySelector;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

class ReadReplicaStartupProcess
implements Lifecycle {
    private final RemoteStore remoteStore;
    private final LocalDatabase localDatabase;
    private final Lifecycle txPulling;
    private final Log debugLog;
    private final Log userLog;
    private final RetryStrategy retryStrategy;
    private final UpstreamDatabaseStrategySelector selectionStrategyPipeline;
    private String lastIssue;
    private final StoreCopyProcess storeCopyProcess;

    ReadReplicaStartupProcess(RemoteStore remoteStore, LocalDatabase localDatabase, Lifecycle txPulling, UpstreamDatabaseStrategySelector selectionStrategyPipeline, RetryStrategy retryStrategy, LogProvider debugLogProvider, LogProvider userLogProvider, StoreCopyProcess storeCopyProcess) {
        this.remoteStore = remoteStore;
        this.localDatabase = localDatabase;
        this.txPulling = txPulling;
        this.selectionStrategyPipeline = selectionStrategyPipeline;
        this.retryStrategy = retryStrategy;
        this.debugLog = debugLogProvider.getLog(this.getClass());
        this.userLog = userLogProvider.getLog(this.getClass());
        this.storeCopyProcess = storeCopyProcess;
    }

    public void init() throws Throwable {
        this.localDatabase.init();
        this.txPulling.init();
    }

    private String issueOf(String operation, int attempt) {
        return String.format("Failed attempt %d of %s", attempt, operation);
    }

    public void start() throws IOException {
        boolean syncedWithUpstream = false;
        RetryStrategy.Timeout timeout = this.retryStrategy.newTimeout();
        int attempt = 0;
        while (!syncedWithUpstream) {
            ++attempt;
            MemberId source = null;
            try {
                source = this.selectionStrategyPipeline.bestUpstreamDatabase();
                this.syncStoreWithUpstream(source);
                syncedWithUpstream = true;
            }
            catch (UpstreamDatabaseSelectionException e) {
                this.lastIssue = this.issueOf("finding upstream member", attempt);
                this.debugLog.warn(this.lastIssue);
            }
            catch (StoreCopyFailedException e) {
                this.lastIssue = this.issueOf(String.format("copying store files from %s", source), attempt);
                this.debugLog.warn(this.lastIssue);
            }
            catch (StreamingTransactionsFailedException e) {
                this.lastIssue = this.issueOf(String.format("streaming transactions from %s", source), attempt);
                this.debugLog.warn(this.lastIssue);
            }
            catch (StoreIdDownloadFailedException e) {
                this.lastIssue = this.issueOf(String.format("getting store id from %s", source), attempt);
                this.debugLog.warn(this.lastIssue);
            }
            try {
                Thread.sleep(timeout.getMillis());
                timeout.increment();
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                this.lastIssue = "Interrupted while trying to start read replica";
                this.debugLog.warn(this.lastIssue);
                break;
            }
        }
        if (!syncedWithUpstream) {
            this.userLog.error(this.lastIssue);
            throw new RuntimeException(this.lastIssue);
        }
        try {
            this.localDatabase.start();
            this.txPulling.start();
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    private void syncStoreWithUpstream(MemberId source) throws IOException, StoreIdDownloadFailedException, StoreCopyFailedException, StreamingTransactionsFailedException {
        if (this.localDatabase.isEmpty()) {
            this.debugLog.info("Local database is empty, attempting to replace with copy from upstream server %s", new Object[]{source});
            this.debugLog.info("Finding store id of upstream server %s", new Object[]{source});
            StoreId storeId = this.remoteStore.getStoreId(source);
            this.debugLog.info("Copying store from upstream server %s", new Object[]{source});
            this.localDatabase.delete();
            this.storeCopyProcess.replaceWithStoreFrom(source, storeId);
            this.debugLog.info("Restarting local database after copy.", new Object[]{source});
        } else {
            this.ensureSameStoreIdAs(source);
        }
    }

    private void ensureSameStoreIdAs(MemberId upstream) throws StoreIdDownloadFailedException {
        StoreId remoteStoreId;
        StoreId localStoreId = this.localDatabase.storeId();
        if (!localStoreId.equals(remoteStoreId = this.remoteStore.getStoreId(upstream))) {
            throw new IllegalStateException(String.format("This read replica cannot join the cluster. The local database is not empty and has a mismatching storeId: expected %s actual %s.", remoteStoreId, localStoreId));
        }
    }

    public void stop() throws Throwable {
        this.txPulling.stop();
        this.localDatabase.stop();
    }

    public void shutdown() throws Throwable {
        this.txPulling.shutdown();
        this.localDatabase.shutdown();
    }
}

