/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.readreplica;

import java.util.Optional;
import org.neo4j.causalclustering.discovery.TopologyService;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.readreplica.UpstreamDatabaseSelectionException;
import org.neo4j.helpers.Service;
import org.neo4j.kernel.configuration.Config;

public abstract class UpstreamDatabaseSelectionStrategy
extends Service {
    protected TopologyService topologyService;
    protected Config config;
    protected MemberId myself;

    public UpstreamDatabaseSelectionStrategy(String key, String ... altKeys) {
        super(key, altKeys);
    }

    void setTopologyService(TopologyService topologyService) {
        this.topologyService = topologyService;
    }

    void setConfig(Config config) {
        this.config = config;
    }

    void setMyself(MemberId myself) {
        this.myself = myself;
    }

    public abstract Optional<MemberId> upstreamDatabase() throws UpstreamDatabaseSelectionException;

    public String toString() {
        return UpstreamDatabaseSelectionStrategy.nicelyCommaSeparatedList(this.getKeys());
    }

    private static String nicelyCommaSeparatedList(Iterable<String> keys) {
        StringBuilder sb = new StringBuilder();
        for (String key : keys) {
            sb.append(key);
            sb.append(",");
            sb.append(" ");
        }
        int trimThese = sb.lastIndexOf(", ");
        if (trimThese > 1) {
            sb.replace(trimThese, sb.length(), "");
        }
        return sb.toString();
    }
}

