/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.readreplica;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.causalclustering.discovery.TopologyService;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.readreplica.UpstreamDatabaseSelectionStrategy;
import org.neo4j.helpers.Service;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

public class UpstreamDatabaseStrategiesLoader
implements Iterable<UpstreamDatabaseSelectionStrategy> {
    private final TopologyService topologyService;
    private final Config config;
    private final MemberId myself;
    private final Log log;

    UpstreamDatabaseStrategiesLoader(TopologyService topologyService, Config config, MemberId myself, LogProvider logProvider) {
        this.topologyService = topologyService;
        this.config = config;
        this.myself = myself;
        this.log = logProvider.getLog(this.getClass());
    }

    @Override
    public Iterator<UpstreamDatabaseSelectionStrategy> iterator() {
        Iterable allImplementationsOnClasspath = Service.load(UpstreamDatabaseSelectionStrategy.class);
        LinkedHashSet<UpstreamDatabaseSelectionStrategy> candidates = new LinkedHashSet<UpstreamDatabaseSelectionStrategy>();
        for (String key : (List)this.config.get(CausalClusteringSettings.upstream_selection_strategy)) {
            for (UpstreamDatabaseSelectionStrategy candidate : allImplementationsOnClasspath) {
                if (!((String)candidate.getKeys().iterator().next()).equals(key)) continue;
                candidate.setTopologyService(this.topologyService);
                candidate.setConfig(this.config);
                candidate.setMyself(this.myself);
                candidates.add(candidate);
            }
        }
        this.log(candidates);
        return candidates.iterator();
    }

    private void log(LinkedHashSet<UpstreamDatabaseSelectionStrategy> candidates) {
        this.log.debug("Upstream database strategies loaded in order of precedence: " + UpstreamDatabaseStrategiesLoader.nicelyCommaSeparatedList(candidates));
    }

    private static String nicelyCommaSeparatedList(Collection<UpstreamDatabaseSelectionStrategy> items) {
        StringBuilder sb = new StringBuilder();
        for (UpstreamDatabaseSelectionStrategy strategy : items) {
            sb.append(strategy.toString());
            sb.append(",");
            sb.append(" ");
        }
        int trimThese = sb.lastIndexOf(", ");
        if (trimThese > 1) {
            sb.replace(trimThese, sb.length(), "");
        }
        return sb.toString();
    }
}

