/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.readreplica;

import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.causalclustering.discovery.CoreServerInfo;
import org.neo4j.causalclustering.discovery.CoreTopology;
import org.neo4j.causalclustering.discovery.ReadReplicaInfo;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.load_balancing.filters.Filter;
import org.neo4j.causalclustering.load_balancing.plugins.server_policies.FilterConfigParser;
import org.neo4j.causalclustering.load_balancing.plugins.server_policies.InvalidFilterSpecification;
import org.neo4j.causalclustering.load_balancing.plugins.server_policies.ServerInfo;
import org.neo4j.causalclustering.readreplica.UpstreamDatabaseSelectionException;
import org.neo4j.causalclustering.readreplica.UpstreamDatabaseSelectionStrategy;

public class UserDefinedConfigurationStrategy
extends UpstreamDatabaseSelectionStrategy {
    public UserDefinedConfigurationStrategy() {
        super("user-defined", new String[0]);
    }

    @Override
    public Optional<MemberId> upstreamDatabase() throws UpstreamDatabaseSelectionException {
        try {
            Filter<ServerInfo> filters = FilterConfigParser.parse((String)this.config.get(CausalClusteringSettings.user_defined_upstream_selection_strategy));
            Set possibleReaders = this.topologyService.readReplicas().members().entrySet().stream().map(entry -> new ServerInfo(((ReadReplicaInfo)entry.getValue()).connectors().boltAddress(), (MemberId)entry.getKey(), ((ReadReplicaInfo)entry.getValue()).groups())).collect(Collectors.toSet());
            CoreTopology coreTopology = this.topologyService.coreServers();
            for (MemberId validCore : coreTopology.members().keySet()) {
                Optional<CoreServerInfo> coreServerInfo = coreTopology.find(validCore);
                if (!coreServerInfo.isPresent()) continue;
                CoreServerInfo serverInfo = coreServerInfo.get();
                possibleReaders.add(new ServerInfo(serverInfo.connectors().boltAddress(), validCore, serverInfo.groups()));
            }
            return filters.apply(possibleReaders).stream().map(ServerInfo::memberId).findAny();
        }
        catch (InvalidFilterSpecification invalidFilterSpecification) {
            return Optional.empty();
        }
    }
}

