/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cloud.storage.queues;

import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import org.neo4j.util.Preconditions;

abstract class RequestQueue
implements AutoCloseable {
    private final Queue<CompletableFuture<ByteBuffer>> queue;
    private final int maxQueueSize;
    private final int chunkSize;
    private final long objectSize;
    private long nextRequestPosition;

    protected RequestQueue(int queueSize, int chunkSize, long objectSize, long startPosition) {
        this.maxQueueSize = Preconditions.requirePositive((int)queueSize);
        this.chunkSize = Preconditions.requirePositive((int)chunkSize);
        this.objectSize = Preconditions.requirePositive((long)objectSize);
        this.nextRequestPosition = Preconditions.requireNonNegative((long)startPosition);
        this.queue = new ArrayDeque<CompletableFuture<ByteBuffer>>(queueSize);
    }

    protected abstract CompletableFuture<ByteBuffer> get(long var1, long var3);

    @Override
    public void close() {
        this.clearQueue();
    }

    protected final long getObjectSize() {
        return this.objectSize;
    }

    protected final int maxQueueSize() {
        return this.maxQueueSize;
    }

    protected final int queueSize() {
        return this.queue.size();
    }

    protected final int chunkSize() {
        return this.chunkSize;
    }

    protected final long nextRequestPosition() {
        return this.nextRequestPosition;
    }

    protected final void setNextRequestPosition(long nextRequestPosition) {
        this.nextRequestPosition = Preconditions.requireNonNegative((long)nextRequestPosition);
    }

    protected final void fillQueue() {
        for (int i = this.queueSize(); i < this.maxQueueSize() && this.maybeRequestChunk(); ++i) {
        }
    }

    protected final CompletableFuture<ByteBuffer> poll(boolean preloadNextRequests) {
        CompletableFuture<ByteBuffer> next = this.queue.poll();
        if (next != null && preloadNextRequests) {
            this.fillQueue();
        }
        return next;
    }

    protected final void clearQueue() {
        for (CompletableFuture completableFuture : this.queue) {
            completableFuture.cancel(true);
        }
        this.queue.clear();
    }

    protected final boolean maybeRequestChunk() {
        long rangeStart = this.nextRequestPosition;
        if (rangeStart >= this.objectSize) {
            return false;
        }
        this.nextRequestPosition += (long)this.chunkSize;
        this.queue.offer(this.request(rangeStart));
        return true;
    }

    protected void onBeforeLoad(long from, long to) {
    }

    private CompletableFuture<ByteBuffer> request(long from) {
        long end = Math.min(from + (long)this.chunkSize, this.objectSize);
        this.onBeforeLoad(from, end);
        return this.get(from, end);
    }
}

