/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cloud.storage;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.Objects;
import org.neo4j.annotations.service.Service;
import org.neo4j.cloud.storage.StorageSystemProvider;
import org.neo4j.configuration.Config;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.memory.MemoryTracker;

@Service
public abstract class StorageSystemProviderFactory {
    private final String scheme;

    protected StorageSystemProviderFactory(String scheme) {
        this.scheme = Objects.requireNonNull(scheme);
    }

    protected abstract String storageSystemProviderClass();

    public String scheme() {
        return this.scheme;
    }

    public boolean matches(String scheme) {
        return Objects.equals(this.scheme, scheme);
    }

    public StorageSystemProvider createStorageSystemProvider(ChunkChannelSupplier chunkSupplier, Config config, InternalLogProvider logProvider, MemoryTracker memoryTracker, ClassLoader classLoader) {
        try {
            return this.loadProviderClass(classLoader).getConstructor(ChunkChannelSupplier.class, Config.class, InternalLogProvider.class, MemoryTracker.class).newInstance(chunkSupplier, config, logProvider, memoryTracker);
        }
        catch (ClassCastException | ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            throw new UncheckedIOException(new IOException("Unable to create the StorageSystemProvider via the class " + this.storageSystemProviderClass(), ex));
        }
    }

    private Class<StorageSystemProvider> loadProviderClass(ClassLoader classLoader) throws ClassNotFoundException {
        return Class.forName(this.storageSystemProviderClass(), true, classLoader);
    }

    @FunctionalInterface
    public static interface ChunkChannelSupplier {
        public ChunkChannel create(String var1) throws IOException;
    }

    public static interface ChunkChannel
    extends AutoCloseable {
        public Path path();

        public void write(ByteBuffer var1) throws IOException;

        @Override
        public void close() throws IOException;
    }
}

