/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cloud.storage.io;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.NonReadableChannelException;
import java.nio.channels.SeekableByteChannel;
import org.neo4j.cloud.storage.io.WriteableChannel;

public class SeekableWriteableChannel<CHANNEL extends WriteableChannel>
implements SeekableByteChannel {
    private final CHANNEL writeChannel;
    private volatile boolean closed;

    public SeekableWriteableChannel(CHANNEL channel) {
        this.writeChannel = channel;
    }

    public OutputStream asStream() throws IOException {
        this.ensureOpen();
        return this.writeChannel;
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        throw new NonReadableChannelException();
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        return ((WriteableChannel)this.writeChannel).write(src);
    }

    @Override
    public long position() throws IOException {
        this.ensureOpen();
        return ((WriteableChannel)this.writeChannel).size();
    }

    @Override
    public SeekableByteChannel position(long newPosition) {
        throw new NonReadableChannelException();
    }

    @Override
    public long size() throws IOException {
        this.ensureOpen();
        return ((WriteableChannel)this.writeChannel).size();
    }

    @Override
    public SeekableByteChannel truncate(long size) {
        throw new UnsupportedOperationException("truncate(size)");
    }

    @Override
    public boolean isOpen() {
        return !this.closed;
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            ((WriteableChannel)this.writeChannel).close();
        }
    }

    private void ensureOpen() throws IOException {
        if (this.closed) {
            throw new ClosedChannelException();
        }
    }
}

