/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cluster.client;

import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.neo4j.cluster.InstanceId;
import org.neo4j.cluster.ProtocolServer;
import org.neo4j.cluster.protocol.cluster.Cluster;
import org.neo4j.cluster.protocol.cluster.ClusterConfiguration;
import org.neo4j.cluster.protocol.cluster.ClusterListener;
import org.neo4j.helpers.HostnamePort;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.logging.Log;

public class ClusterJoin
extends LifecycleAdapter {
    private final Configuration config;
    private final ProtocolServer protocolServer;
    private final Log userLog;
    private final Log messagesLog;
    private Cluster cluster;

    public ClusterJoin(Configuration config, ProtocolServer protocolServer, LogService logService) {
        this.config = config;
        this.protocolServer = protocolServer;
        this.userLog = logService.getUserLog(((Object)((Object)this)).getClass());
        this.messagesLog = logService.getInternalLog(((Object)((Object)this)).getClass());
    }

    public void start() throws Throwable {
        this.cluster = this.protocolServer.newClient(Cluster.class);
        this.joinByConfig();
    }

    public void stop() {
        final Semaphore semaphore = new Semaphore(0);
        this.cluster.addClusterListener(new ClusterListener.Adapter(){

            @Override
            public void leftCluster() {
                ClusterJoin.this.cluster.removeClusterListener(this);
                semaphore.release();
            }
        });
        this.cluster.leave();
        try {
            if (!semaphore.tryAcquire(60L, TimeUnit.SECONDS)) {
                this.messagesLog.info("Unable to leave cluster, timeout");
            }
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            this.messagesLog.warn("Unable to leave cluster, interrupted", (Throwable)e);
        }
    }

    private void joinByConfig() throws TimeoutException {
        List<HostnamePort> hosts = this.config.getInitialHosts();
        this.cluster.addClusterListener(new UnknownJoiningMemberWarning(hosts));
        if (hosts == null || hosts.size() == 0) {
            this.userLog.info("No cluster hosts specified. Creating cluster %s", new Object[]{this.config.getClusterName()});
            this.cluster.create(this.config.getClusterName());
        } else {
            URI[] memberURIs = (URI[])hosts.stream().map(member -> URI.create("cluster://" + this.resolvePortOnlyHost((HostnamePort)member))).toArray(URI[]::new);
            while (true) {
                this.userLog.info("Attempting to join cluster of %s", new Object[]{hosts.toString()});
                Future<ClusterConfiguration> clusterConfig = this.cluster.join(this.config.getClusterName(), memberURIs);
                try {
                    ClusterConfiguration clusterConf = this.config.getClusterJoinTimeout() > 0L ? clusterConfig.get(this.config.getClusterJoinTimeout(), TimeUnit.MILLISECONDS) : clusterConfig.get();
                    this.userLog.info("Joined cluster: %s", new Object[]{clusterConf});
                    return;
                }
                catch (InterruptedException e) {
                    this.userLog.warn("Could not join cluster, interrupted. Retrying...");
                    continue;
                }
                catch (ExecutionException e) {
                    this.messagesLog.debug("Could not join cluster " + this.config.getClusterName());
                    if (e.getCause() instanceof IllegalStateException) {
                        throw (IllegalStateException)e.getCause();
                    }
                    if (this.config.isAllowedToCreateCluster()) {
                        this.userLog.info("Could not join cluster of %s", new Object[]{hosts.toString()});
                        this.userLog.info("Creating new cluster with name [%s]...", new Object[]{this.config.getClusterName()});
                        this.cluster.create(this.config.getClusterName());
                        break;
                    }
                    this.userLog.warn("Could not join cluster, timed out. Retrying...");
                    continue;
                }
                break;
            }
        }
    }

    private String resolvePortOnlyHost(HostnamePort host) {
        try {
            return host.toString(InetAddress.getLocalHost().getHostAddress());
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }

    private class UnknownJoiningMemberWarning
    extends ClusterListener.Adapter {
        private final List<HostnamePort> initialHosts;

        private UnknownJoiningMemberWarning(List<HostnamePort> initialHosts) {
            this.initialHosts = initialHosts;
        }

        @Override
        public void joinedCluster(InstanceId member, URI uri) {
            for (HostnamePort host : this.initialHosts) {
                if (!host.matches(uri)) continue;
                return;
            }
            ClusterJoin.this.messagesLog.info("Member " + member + "(" + uri + ") joined cluster but was not part of initial hosts (" + this.initialHosts + ")");
        }

        @Override
        public void leftCluster() {
            ClusterJoin.this.cluster.removeClusterListener(this);
        }
    }

    public static interface Configuration {
        public List<HostnamePort> getInitialHosts();

        public String getClusterName();

        public boolean isAllowedToCreateCluster();

        public long getClusterJoinTimeout();
    }
}

