/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cluster.protocol.atomicbroadcast;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.Field;
import org.neo4j.cluster.protocol.atomicbroadcast.VersionMapper;

public class LenientObjectOutputStream
extends ObjectOutputStream {
    private VersionMapper versionMapper;

    public LenientObjectOutputStream(ByteArrayOutputStream bout, VersionMapper versionMapper) throws IOException {
        super(bout);
        this.versionMapper = versionMapper;
    }

    @Override
    protected void writeClassDescriptor(ObjectStreamClass desc) throws IOException {
        if (this.versionMapper.hasMappingFor(desc.getName())) {
            this.updateWirePayloadSuid(desc);
        }
        super.writeClassDescriptor(desc);
    }

    private void updateWirePayloadSuid(ObjectStreamClass wirePayload) {
        try {
            Field field = this.getAccessibleSuidField(wirePayload);
            field.set(wirePayload, this.versionMapper.mappingFor(wirePayload.getName()));
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private Field getAccessibleSuidField(ObjectStreamClass localClassDescriptor) throws NoSuchFieldException {
        Field suidField = localClassDescriptor.getClass().getDeclaredField("suid");
        suidField.setAccessible(true);
        return suidField;
    }
}

