/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cluster.protocol.atomicbroadcast.multipaxos;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import org.neo4j.cluster.protocol.atomicbroadcast.multipaxos.InstanceId;
import org.neo4j.cluster.protocol.atomicbroadcast.multipaxos.PaxosInstance;

public class PaxosInstanceStore {
    private static final int MAX_STORED = 5000;
    private int queued = 0;
    private Queue<InstanceId> delivered = new LinkedList<InstanceId>();
    private Map<InstanceId, PaxosInstance> instances = new HashMap<InstanceId, PaxosInstance>();
    private final int maxInstancesToStore;

    public PaxosInstanceStore() {
        this(5000);
    }

    public PaxosInstanceStore(int maxInstancesToStore) {
        this.maxInstancesToStore = maxInstancesToStore;
    }

    public PaxosInstance getPaxosInstance(InstanceId instanceId) {
        if (instanceId == null) {
            throw new NullPointerException("InstanceId may not be null");
        }
        PaxosInstance instance = this.instances.get(instanceId);
        if (instance == null) {
            instance = new PaxosInstance(this, instanceId);
            this.instances.put(instanceId, instance);
        }
        return instance;
    }

    public void delivered(InstanceId instanceId) {
        ++this.queued;
        this.delivered.offer(instanceId);
        if (this.queued > this.maxInstancesToStore) {
            InstanceId removeInstanceId = this.delivered.poll();
            this.instances.remove(removeInstanceId);
            --this.queued;
        }
    }

    public void leave() {
        this.queued = 0;
        this.delivered.clear();
        this.instances.clear();
    }

    public PaxosInstanceStore snapshot() {
        PaxosInstanceStore snapshotStore = new PaxosInstanceStore();
        snapshotStore.queued = this.queued;
        snapshotStore.delivered = new LinkedList<InstanceId>(this.delivered);
        for (Map.Entry<InstanceId, PaxosInstance> instance : this.instances.entrySet()) {
            snapshotStore.instances.put(instance.getKey(), instance.getValue().snapshot(snapshotStore));
        }
        return snapshotStore;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaxosInstanceStore that = (PaxosInstanceStore)o;
        if (this.queued != that.queued) {
            return false;
        }
        if (!this.delivered.equals(that.delivered)) {
            return false;
        }
        return this.instances.equals(that.instances);
    }

    public int hashCode() {
        int result = this.queued;
        result = 31 * result + this.delivered.hashCode();
        result = 31 * result + this.instances.hashCode();
        return result;
    }
}

