/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cluster.protocol.atomicbroadcast.multipaxos.context;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import org.neo4j.cluster.InstanceId;
import org.neo4j.cluster.protocol.atomicbroadcast.ObjectInputStreamFactory;
import org.neo4j.cluster.protocol.atomicbroadcast.ObjectOutputStreamFactory;
import org.neo4j.cluster.protocol.atomicbroadcast.multipaxos.LearnerContext;
import org.neo4j.cluster.protocol.atomicbroadcast.multipaxos.context.AbstractContextImpl;
import org.neo4j.cluster.protocol.atomicbroadcast.multipaxos.context.CommonContextState;
import org.neo4j.cluster.protocol.atomicbroadcast.multipaxos.context.HeartbeatContextImpl;
import org.neo4j.cluster.protocol.atomicbroadcast.multipaxos.context.LearnerContextImpl;
import org.neo4j.cluster.protocol.cluster.ClusterConfiguration;
import org.neo4j.cluster.protocol.cluster.ClusterContext;
import org.neo4j.cluster.protocol.cluster.ClusterListener;
import org.neo4j.cluster.protocol.cluster.ClusterMessage;
import org.neo4j.cluster.protocol.heartbeat.HeartbeatContext;
import org.neo4j.cluster.protocol.heartbeat.HeartbeatListener;
import org.neo4j.cluster.timeout.Timeouts;
import org.neo4j.function.Predicates;
import org.neo4j.helpers.Listeners;
import org.neo4j.helpers.Uris;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.logging.LogProvider;

class ClusterContextImpl
extends AbstractContextImpl
implements ClusterContext {
    private final Listeners<ClusterListener> clusterListeners = new Listeners();
    private final List<ClusterMessage.ConfigurationRequestState> discoveredInstances = new ArrayList<ClusterMessage.ConfigurationRequestState>();
    private Iterable<URI> joiningInstances;
    private ClusterMessage.ConfigurationResponseState joinDeniedConfigurationResponseState;
    private final Map<InstanceId, URI> currentlyJoiningInstances = new HashMap<InstanceId, URI>();
    private final Executor executor;
    private final ObjectOutputStreamFactory objectOutputStreamFactory;
    private final ObjectInputStreamFactory objectInputStreamFactory;
    private final LearnerContext learnerContext;
    private final HeartbeatContext heartbeatContext;
    private long electorVersion;
    private InstanceId lastElector;

    ClusterContextImpl(InstanceId me, CommonContextState commonState, LogProvider logging, Timeouts timeouts, Executor executor, ObjectOutputStreamFactory objectOutputStreamFactory, ObjectInputStreamFactory objectInputStreamFactory, LearnerContext learnerContext, HeartbeatContext heartbeatContext) {
        super(me, commonState, logging, timeouts);
        this.executor = executor;
        this.objectOutputStreamFactory = objectOutputStreamFactory;
        this.objectInputStreamFactory = objectInputStreamFactory;
        this.learnerContext = learnerContext;
        this.heartbeatContext = heartbeatContext;
        heartbeatContext.addHeartbeatListener(new HeartbeatListener.Adapter(){

            @Override
            public void failed(InstanceId server) {
                ClusterContextImpl.this.invalidateElectorIfNecessary(server);
            }
        });
    }

    private void invalidateElectorIfNecessary(InstanceId server) {
        if (server.equals(this.lastElector)) {
            this.lastElector = InstanceId.NONE;
            this.electorVersion = -1L;
        }
    }

    private ClusterContextImpl(InstanceId me, CommonContextState commonState, LogProvider logging, Timeouts timeouts, Iterable<URI> joiningInstances, ClusterMessage.ConfigurationResponseState joinDeniedConfigurationResponseState, Executor executor, ObjectOutputStreamFactory objectOutputStreamFactory, ObjectInputStreamFactory objectInputStreamFactory, LearnerContext learnerContext, HeartbeatContext heartbeatContext) {
        super(me, commonState, logging, timeouts);
        this.joiningInstances = joiningInstances;
        this.joinDeniedConfigurationResponseState = joinDeniedConfigurationResponseState;
        this.executor = executor;
        this.objectOutputStreamFactory = objectOutputStreamFactory;
        this.objectInputStreamFactory = objectInputStreamFactory;
        this.learnerContext = learnerContext;
        this.heartbeatContext = heartbeatContext;
    }

    @Override
    public long getLastElectorVersion() {
        return this.electorVersion;
    }

    @Override
    public void setLastElectorVersion(long lastElectorVersion) {
        this.electorVersion = lastElectorVersion;
    }

    @Override
    public InstanceId getLastElector() {
        return this.lastElector;
    }

    @Override
    public void setLastElector(InstanceId lastElector) {
        this.lastElector = lastElector;
    }

    @Override
    public void addClusterListener(ClusterListener listener) {
        this.clusterListeners.add((Object)listener);
    }

    @Override
    public void removeClusterListener(ClusterListener listener) {
        this.clusterListeners.remove((Object)listener);
    }

    @Override
    public void created(String name) {
        this.commonState.setConfiguration(new ClusterConfiguration(name, this.logProvider, Collections.singleton(this.commonState.boundAt())));
        this.joined();
    }

    @Override
    public void joining(String name, Iterable<URI> instanceList) {
        this.joiningInstances = instanceList;
        this.discoveredInstances.clear();
        this.joinDeniedConfigurationResponseState = null;
    }

    @Override
    public void acquiredConfiguration(Map<InstanceId, URI> memberList, Map<String, InstanceId> roles) {
        this.commonState.configuration().setMembers(memberList);
        this.commonState.configuration().setRoles(roles);
    }

    @Override
    public void joined() {
        this.commonState.configuration().joined(this.me, this.commonState.boundAt());
        this.clusterListeners.notify(this.executor, listener -> listener.enteredCluster(this.commonState.configuration()));
    }

    @Override
    public void left() {
        this.timeouts.cancelAllTimeouts();
        this.commonState.configuration().left();
        this.clusterListeners.notify(this.executor, ClusterListener::leftCluster);
    }

    @Override
    public void joined(InstanceId instanceId, URI atURI) {
        this.commonState.configuration().joined(instanceId, atURI);
        if (this.commonState.configuration().getMembers().containsKey(this.me)) {
            this.clusterListeners.notify(this.executor, listener -> listener.joinedCluster(instanceId, atURI));
        }
        this.currentlyJoiningInstances.remove(instanceId);
        this.invalidateElectorIfNecessary(instanceId);
    }

    @Override
    public void left(InstanceId node) {
        URI member = this.commonState.configuration().getUriForId(node);
        this.commonState.configuration().left(node);
        this.invalidateElectorIfNecessary(node);
        this.clusterListeners.notify(this.executor, listener -> listener.leftCluster(node, member));
    }

    @Override
    public void elected(String roleName, InstanceId instanceId) {
        this.elected(roleName, instanceId, InstanceId.NONE, -1L);
    }

    @Override
    public void elected(String roleName, InstanceId instanceId, InstanceId electorId, long version) {
        if (electorId != null) {
            if (electorId.equals(this.getMyId())) {
                this.getLog((Class)this.getClass()).debug("I elected instance " + instanceId + " for role " + roleName + " at version " + version);
                if (version < this.electorVersion) {
                    return;
                }
            } else {
                if (electorId.equals(this.lastElector) && version < this.electorVersion && version > 1L) {
                    this.getLog((Class)this.getClass()).warn("Election result for role " + roleName + " received from elector instance " + electorId + " with version " + version + ". I had version " + this.electorVersion + " for elector " + this.lastElector);
                    return;
                }
                this.getLog((Class)this.getClass()).debug("Setting elector to " + electorId + " and its version to " + version);
            }
            this.electorVersion = version;
            this.lastElector = electorId;
        }
        this.commonState.configuration().elected(roleName, instanceId);
        this.clusterListeners.notify(this.executor, listener -> listener.elected(roleName, instanceId, this.commonState.configuration().getUriForId(instanceId)));
    }

    @Override
    public void unelected(String roleName, InstanceId instanceId) {
        this.unelected(roleName, instanceId, InstanceId.NONE, -1L);
    }

    @Override
    public void unelected(String roleName, InstanceId instanceId, InstanceId electorId, long version) {
        this.commonState.configuration().unelected(roleName);
        this.clusterListeners.notify(this.executor, listener -> listener.unelected(roleName, instanceId, this.commonState.configuration().getUriForId(instanceId)));
    }

    @Override
    public ClusterConfiguration getConfiguration() {
        return this.commonState.configuration();
    }

    @Override
    public boolean isElectedAs(String roleName) {
        return this.me.equals(this.commonState.configuration().getElected(roleName));
    }

    @Override
    public boolean isInCluster() {
        return Iterables.count(this.commonState.configuration().getMemberURIs()) != 0L;
    }

    @Override
    public Iterable<URI> getJoiningInstances() {
        return this.joiningInstances;
    }

    @Override
    public ObjectOutputStreamFactory getObjectOutputStreamFactory() {
        return this.objectOutputStreamFactory;
    }

    @Override
    public ObjectInputStreamFactory getObjectInputStreamFactory() {
        return this.objectInputStreamFactory;
    }

    @Override
    public List<ClusterMessage.ConfigurationRequestState> getDiscoveredInstances() {
        return this.discoveredInstances;
    }

    public String toString() {
        return "Me: " + this.me + " Bound at: " + this.commonState.boundAt() + " Config:" + this.commonState.configuration();
    }

    @Override
    public void setBoundAt(URI boundAt) {
        this.commonState.setBoundAt(this.me, boundAt);
    }

    @Override
    public void joinDenied(ClusterMessage.ConfigurationResponseState configurationResponseState) {
        if (configurationResponseState == null) {
            throw new IllegalArgumentException("Join denied configuration response state was null");
        }
        this.joinDeniedConfigurationResponseState = configurationResponseState;
    }

    @Override
    public boolean hasJoinBeenDenied() {
        return this.joinDeniedConfigurationResponseState != null;
    }

    @Override
    public ClusterMessage.ConfigurationResponseState getJoinDeniedConfigurationResponseState() {
        if (!this.hasJoinBeenDenied()) {
            throw new IllegalStateException("Join has not been denied");
        }
        return this.joinDeniedConfigurationResponseState;
    }

    @Override
    public Iterable<InstanceId> getOtherInstances() {
        return Iterables.filter(Predicates.in((Object[])new InstanceId[]{this.me}).negate(), this.commonState.configuration().getMemberIds());
    }

    @Override
    public boolean isInstanceJoiningFromDifferentUri(InstanceId joiningId, URI uri) {
        return this.currentlyJoiningInstances.containsKey(joiningId) && !this.currentlyJoiningInstances.get(joiningId).equals(uri);
    }

    @Override
    public void instanceIsJoining(InstanceId joiningId, URI uri) {
        this.currentlyJoiningInstances.put(joiningId, uri);
    }

    @Override
    public String myName() {
        String name = (String)Uris.parameter((String)"name").apply(this.commonState.boundAt());
        if (name != null) {
            return name;
        }
        return this.me.toString();
    }

    @Override
    public void discoveredLastReceivedInstanceId(long id) {
        this.learnerContext.setLastDeliveredInstanceId(id);
        this.learnerContext.learnedInstanceId(id);
        this.learnerContext.setNextInstanceId(id + 1L);
    }

    @Override
    public boolean isCurrentlyAlive(InstanceId joiningId) {
        return !this.heartbeatContext.getFailed().contains(joiningId);
    }

    @Override
    public long getLastDeliveredInstanceId() {
        return this.learnerContext.getLastDeliveredInstanceId();
    }

    public ClusterContextImpl snapshot(CommonContextState commonStateSnapshot, LogProvider logging, Timeouts timeouts, Executor executor, ObjectOutputStreamFactory objectOutputStreamFactory, ObjectInputStreamFactory objectInputStreamFactory, LearnerContextImpl snapshotLearnerContext, HeartbeatContextImpl snapshotHeartbeatContext) {
        return new ClusterContextImpl(this.me, commonStateSnapshot, logging, timeouts, this.joiningInstances == null ? null : new ArrayList<URI>(Iterables.asList(this.joiningInstances)), this.joinDeniedConfigurationResponseState == null ? null : this.joinDeniedConfigurationResponseState.snapshot(), executor, objectOutputStreamFactory, objectInputStreamFactory, snapshotLearnerContext, snapshotHeartbeatContext);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterContextImpl that = (ClusterContextImpl)o;
        if (this.currentlyJoiningInstances != null ? !this.currentlyJoiningInstances.equals(that.currentlyJoiningInstances) : that.currentlyJoiningInstances != null) {
            return false;
        }
        if (this.discoveredInstances != null ? !this.discoveredInstances.equals(that.discoveredInstances) : that.discoveredInstances != null) {
            return false;
        }
        if (this.heartbeatContext != null ? !this.heartbeatContext.equals(that.heartbeatContext) : that.heartbeatContext != null) {
            return false;
        }
        if (this.joinDeniedConfigurationResponseState != null ? !this.joinDeniedConfigurationResponseState.equals(that.joinDeniedConfigurationResponseState) : that.joinDeniedConfigurationResponseState != null) {
            return false;
        }
        if (this.joiningInstances != null ? !this.joiningInstances.equals(that.joiningInstances) : that.joiningInstances != null) {
            return false;
        }
        return !(this.learnerContext != null ? !this.learnerContext.equals(that.learnerContext) : that.learnerContext != null);
    }

    public int hashCode() {
        int result = 0;
        result = 31 * result + (this.discoveredInstances != null ? this.discoveredInstances.hashCode() : 0);
        result = 31 * result + (this.joiningInstances != null ? this.joiningInstances.hashCode() : 0);
        result = 31 * result + (this.joinDeniedConfigurationResponseState != null ? this.joinDeniedConfigurationResponseState.hashCode() : 0);
        result = 31 * result + (this.currentlyJoiningInstances != null ? this.currentlyJoiningInstances.hashCode() : 0);
        result = 31 * result + (this.learnerContext != null ? this.learnerContext.hashCode() : 0);
        result = 31 * result + (this.heartbeatContext != null ? this.heartbeatContext.hashCode() : 0);
        return result;
    }
}

