/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cluster.protocol.cluster;

import java.io.Serializable;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.cluster.InstanceId;
import org.neo4j.cluster.com.message.MessageType;
import org.neo4j.cluster.protocol.cluster.ClusterContext;

public enum ClusterMessage implements MessageType
{
    create,
    createResponse,
    join,
    joinResponse,
    leave,
    leaveResponse,
    addClusterListener,
    removeClusterListener,
    joining,
    joiningTimeout,
    configurationRequest,
    configurationResponse,
    configurationTimeout,
    configurationChanged,
    joinDenied,
    joinFailure,
    leaveTimedout;


    public static class ConfigurationTimeoutState {
        private final int remainingPings;

        public ConfigurationTimeoutState(int remainingPings) {
            this.remainingPings = remainingPings;
        }

        public int getRemainingPings() {
            return this.remainingPings;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConfigurationTimeoutState that = (ConfigurationTimeoutState)o;
            return this.remainingPings == that.remainingPings;
        }

        public int hashCode() {
            return this.remainingPings;
        }

        public String toString() {
            return "ConfigurationTimeoutState{remainingPings=" + this.remainingPings + "}";
        }
    }

    public static class VersionedConfigurationStateChange
    extends ConfigurationChangeState {
        private InstanceId elector;
        private long version;

        public InstanceId getElector() {
            return this.elector;
        }

        public void setElector(InstanceId elector) {
            this.elector = elector;
        }

        public long getVersion() {
            return this.version;
        }

        public void setVersion(long version) {
            this.version = version;
        }

        @Override
        public void apply(ClusterContext context) {
            if (this.getJoin() != null) {
                context.joined(this.getJoin(), this.getJoinUri());
            }
            if (this.getLeave() != null) {
                context.left(this.getLeave());
            }
            if (this.getRoleWon() != null) {
                context.elected(this.getRoleWon(), this.getWinner(), this.elector, this.version);
            }
            if (this.getRoleLost() != null) {
                context.unelected(this.getRoleLost(), this.getLoser(), this.elector, this.version);
            }
        }

        @Override
        public String toString() {
            return "VersionedConfigurationStateChange{elector=" + this.elector + ", version=" + this.version + "} " + super.toString();
        }
    }

    public static class ConfigurationChangeState
    implements Serializable {
        private static final long serialVersionUID = 3798148961231305356L;
        private InstanceId join;
        private URI joinUri;
        private InstanceId leave;
        private String roleWon;
        private InstanceId winner;
        private String roleLost;
        private InstanceId loser;

        public void join(InstanceId join, URI joinUri) {
            this.join = join;
            this.joinUri = joinUri;
        }

        public void leave(InstanceId uri) {
            this.leave = uri;
        }

        public void elected(String role, InstanceId winner) {
            this.roleWon = role;
            this.winner = winner;
        }

        public void unelected(String role, InstanceId unelected) {
            this.roleLost = role;
            this.loser = unelected;
        }

        public InstanceId getJoin() {
            return this.join;
        }

        public URI getJoinUri() {
            return this.joinUri;
        }

        public InstanceId getLeave() {
            return this.leave;
        }

        public void apply(ClusterContext context) {
            if (this.join != null) {
                context.joined(this.join, this.joinUri);
            }
            if (this.leave != null) {
                context.left(this.leave);
            }
            if (this.roleWon != null) {
                context.elected(this.roleWon, this.winner);
            }
            if (this.roleLost != null) {
                context.unelected(this.roleLost, this.loser);
            }
        }

        protected InstanceId getWinner() {
            return this.winner;
        }

        protected String getRoleWon() {
            return this.roleWon;
        }

        protected InstanceId getLoser() {
            return this.loser;
        }

        protected String getRoleLost() {
            return this.roleLost;
        }

        public boolean isLeaving(InstanceId me) {
            return me.equals(this.leave);
        }

        public String toString() {
            if (this.join != null) {
                return "Change cluster config, join:" + this.join;
            }
            if (this.leave != null) {
                return "Change cluster config, leave:" + this.leave;
            }
            if (this.roleWon != null) {
                return "Change cluster config, elected:" + this.winner + " as " + this.roleWon;
            }
            return "Change cluster config, unelected:" + this.loser + " as " + this.roleWon;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConfigurationChangeState that = (ConfigurationChangeState)o;
            if (this.join != null ? !this.join.equals(that.join) : that.join != null) {
                return false;
            }
            if (this.joinUri != null ? !this.joinUri.equals(that.joinUri) : that.joinUri != null) {
                return false;
            }
            if (this.leave != null ? !this.leave.equals(that.leave) : that.leave != null) {
                return false;
            }
            if (this.loser != null ? !this.loser.equals(that.loser) : that.loser != null) {
                return false;
            }
            if (this.roleLost != null ? !this.roleLost.equals(that.roleLost) : that.roleLost != null) {
                return false;
            }
            if (this.roleWon != null ? !this.roleWon.equals(that.roleWon) : that.roleWon != null) {
                return false;
            }
            return !(this.winner != null ? !this.winner.equals(that.winner) : that.winner != null);
        }

        public int hashCode() {
            int result = this.join != null ? this.join.hashCode() : 0;
            result = 31 * result + (this.joinUri != null ? this.joinUri.hashCode() : 0);
            result = 31 * result + (this.leave != null ? this.leave.hashCode() : 0);
            result = 31 * result + (this.roleWon != null ? this.roleWon.hashCode() : 0);
            result = 31 * result + (this.winner != null ? this.winner.hashCode() : 0);
            result = 31 * result + (this.roleLost != null ? this.roleLost.hashCode() : 0);
            result = 31 * result + (this.loser != null ? this.loser.hashCode() : 0);
            return result;
        }
    }

    public static class ConfigurationResponseState
    implements Serializable {
        private static final long serialVersionUID = -2394291383400324304L;
        private Map<InstanceId, URI> nodes;
        private org.neo4j.cluster.protocol.atomicbroadcast.multipaxos.InstanceId latestReceivedInstanceId;
        private Map<String, InstanceId> roles;
        private String clusterName;

        public ConfigurationResponseState(Map<String, InstanceId> roles, Map<InstanceId, URI> nodes, org.neo4j.cluster.protocol.atomicbroadcast.multipaxos.InstanceId latestReceivedInstanceId, String clusterName) {
            this.roles = roles;
            this.nodes = nodes;
            this.latestReceivedInstanceId = latestReceivedInstanceId;
            this.clusterName = clusterName;
        }

        public Map<InstanceId, URI> getMembers() {
            return this.nodes;
        }

        public Map<String, InstanceId> getRoles() {
            return this.roles;
        }

        public org.neo4j.cluster.protocol.atomicbroadcast.multipaxos.InstanceId getLatestReceivedInstanceId() {
            return this.latestReceivedInstanceId;
        }

        public String getClusterName() {
            return this.clusterName;
        }

        public ConfigurationResponseState snapshot() {
            return new ConfigurationResponseState(new HashMap<String, InstanceId>(this.roles), new HashMap<InstanceId, URI>(this.nodes), this.latestReceivedInstanceId, this.clusterName);
        }

        public String toString() {
            return "ConfigurationResponseState{nodes=" + this.nodes + ", latestReceivedInstanceId=" + this.latestReceivedInstanceId + ", roles=" + this.roles + ", clusterName='" + this.clusterName + '\'' + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConfigurationResponseState that = (ConfigurationResponseState)o;
            if (this.clusterName != null ? !this.clusterName.equals(that.clusterName) : that.clusterName != null) {
                return false;
            }
            if (this.latestReceivedInstanceId != null ? !this.latestReceivedInstanceId.equals(that.latestReceivedInstanceId) : that.latestReceivedInstanceId != null) {
                return false;
            }
            if (this.nodes != null ? !this.nodes.equals(that.nodes) : that.nodes != null) {
                return false;
            }
            return !(this.roles != null ? !this.roles.equals(that.roles) : that.roles != null);
        }

        public int hashCode() {
            int result = this.nodes != null ? this.nodes.hashCode() : 0;
            result = 31 * result + (this.latestReceivedInstanceId != null ? this.latestReceivedInstanceId.hashCode() : 0);
            result = 31 * result + (this.roles != null ? this.roles.hashCode() : 0);
            result = 31 * result + (this.clusterName != null ? this.clusterName.hashCode() : 0);
            return result;
        }
    }

    public static class ConfigurationRequestState
    implements Serializable,
    Comparable<ConfigurationRequestState> {
        private static final long serialVersionUID = -221752558518247157L;
        private InstanceId joiningId;
        private URI joiningUri;

        public ConfigurationRequestState(InstanceId joiningId, URI joiningUri) {
            this.joiningId = joiningId;
            this.joiningUri = joiningUri;
        }

        public InstanceId getJoiningId() {
            return this.joiningId;
        }

        public URI getJoiningUri() {
            return this.joiningUri;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConfigurationRequestState that = (ConfigurationRequestState)o;
            if (!this.joiningId.equals(that.joiningId)) {
                return false;
            }
            return this.joiningUri.equals(that.joiningUri);
        }

        public int hashCode() {
            int result = this.joiningId.hashCode();
            result = 31 * result + this.joiningUri.hashCode();
            return result;
        }

        @Override
        public int compareTo(ConfigurationRequestState o) {
            return this.joiningId.compareTo(o.joiningId);
        }

        public String toString() {
            return "ConfigurationRequestState{joiningId=" + this.joiningId + ", joiningUri=" + this.joiningUri + "}";
        }
    }
}

