/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cluster.protocol.election;

import java.net.URI;
import org.neo4j.cluster.InstanceId;
import org.neo4j.cluster.protocol.cluster.ClusterListener;
import org.neo4j.cluster.protocol.election.Election;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

public class ClusterLeaveReelectionListener
extends ClusterListener.Adapter {
    private final Election election;
    private final Log log;

    public ClusterLeaveReelectionListener(Election election, LogProvider logProvider) {
        this.election = election;
        this.log = logProvider.getLog(this.getClass());
    }

    @Override
    public void leftCluster(InstanceId instanceId, URI member) {
        String name = instanceId.instanceNameFromURI(member);
        this.log.warn("Demoting member " + name + " because it left the cluster");
        this.election.demote(instanceId);
    }
}

