/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cluster.protocol.election;

import java.io.Serializable;
import org.neo4j.cluster.InstanceId;
import org.neo4j.cluster.com.message.MessageType;
import org.neo4j.cluster.protocol.election.ElectionCredentials;

public enum ElectionMessage implements MessageType
{
    created,
    join,
    leave,
    demote,
    performRoleElections,
    vote,
    electionTimeout,
    voted;


    public static class VersionedVotedData
    extends VotedData {
        private static final long serialVersionUID = -3795472557085578559L;
        private long version;

        public VersionedVotedData(String role, InstanceId instanceId, ElectionCredentials electionCredentials, long version) {
            super(role, instanceId, electionCredentials);
            this.version = version;
        }

        public long getVersion() {
            return this.version;
        }

        @Override
        protected String getImplementationSpecificDetails() {
            return "version: " + this.version;
        }
    }

    public static class VotedData
    implements Serializable {
        private static final long serialVersionUID = 6115474263667086327L;
        private String role;
        private InstanceId instanceId;
        private ElectionCredentials voteCredentials;

        public VotedData(String role, InstanceId instanceId, ElectionCredentials electionCredentials) {
            this.role = role;
            this.instanceId = instanceId;
            this.voteCredentials = electionCredentials;
        }

        public String getRole() {
            return this.role;
        }

        public InstanceId getInstanceId() {
            return this.instanceId;
        }

        public ElectionCredentials getElectionCredentials() {
            return this.voteCredentials;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[role:" + this.role + ", instance:" + this.instanceId + ", credentials:" + this.voteCredentials + ", " + this.getImplementationSpecificDetails() + "]";
        }

        protected String getImplementationSpecificDetails() {
            return "";
        }
    }
}

