/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cluster.protocol.heartbeat;

import java.net.URI;
import java.net.URISyntaxException;
import org.neo4j.cluster.InstanceId;
import org.neo4j.cluster.com.message.Message;
import org.neo4j.cluster.com.message.MessageHolder;
import org.neo4j.cluster.com.message.MessageProcessor;
import org.neo4j.cluster.com.message.MessageType;
import org.neo4j.cluster.protocol.cluster.ClusterContext;
import org.neo4j.cluster.protocol.heartbeat.HeartbeatMessage;

public class HeartbeatRefreshProcessor
implements MessageProcessor {
    private final MessageHolder outgoing;
    private final ClusterContext clusterContext;

    public HeartbeatRefreshProcessor(MessageHolder outgoing, ClusterContext clusterContext) {
        this.outgoing = outgoing;
        this.clusterContext = clusterContext;
    }

    @Override
    public boolean process(Message<? extends MessageType> message) {
        if (!message.isInternal() && !message.getMessageType().equals(HeartbeatMessage.i_am_alive)) {
            try {
                String to = message.getHeader("to");
                InstanceId serverId = this.clusterContext.getConfiguration().getIdForUri(new URI(to));
                if (!this.clusterContext.isMe(serverId)) {
                    this.outgoing.offer(Message.internal(HeartbeatMessage.reset_send_heartbeat, serverId));
                }
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        }
        return true;
    }
}

