/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cluster.statemachine;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.neo4j.cluster.com.message.Message;
import org.neo4j.cluster.com.message.MessageHolder;
import org.neo4j.cluster.com.message.MessageType;
import org.neo4j.cluster.statemachine.State;
import org.neo4j.cluster.statemachine.StateTransition;
import org.neo4j.cluster.statemachine.StateTransitionListener;

public class StateMachineRules
implements StateTransitionListener {
    private final MessageHolder outgoing;
    private Map<State<?, ?>, List<StateMachineRule>> rules = new HashMap();

    public StateMachineRules(MessageHolder outgoing) {
        this.outgoing = outgoing;
    }

    public StateMachineRules rule(State<?, ?> oldState, MessageType messageType, State<?, ?> newState, Message<?> ... messages) {
        List<StateMachineRule> fromRules = this.rules.get(oldState);
        if (fromRules == null) {
            fromRules = new ArrayList<StateMachineRule>();
            this.rules.put(oldState, fromRules);
        }
        fromRules.add(new StateMachineRule(oldState, messageType, newState, messages));
        return this;
    }

    @Override
    public void stateTransition(StateTransition transition) {
        List<StateMachineRule> oldStateRules = this.rules.get(transition.getOldState());
        if (oldStateRules != null) {
            for (StateMachineRule oldStateRule : oldStateRules) {
                oldStateRule.stateTransition(transition);
            }
        }
    }

    private class StateMachineRule
    implements StateTransitionListener {
        State<?, ?> oldState;
        MessageType messageType;
        State<?, ?> newState;
        Message<?>[] messages;

        private StateMachineRule(State<?, ?> oldState, MessageType messageType, State<?, ?> newState, Message<?>[] messages) {
            this.oldState = oldState;
            this.messageType = messageType;
            this.newState = newState;
            this.messages = messages;
        }

        @Override
        public void stateTransition(StateTransition transition) {
            if (this.oldState.equals(transition.getOldState()) && transition.getMessage().getMessageType().equals(this.messageType) && this.newState.equals(transition.getNewState())) {
                for (Message<?> message : this.messages) {
                    StateMachineRules.this.outgoing.offer(message);
                }
            }
        }
    }
}

