/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cluster.timeout;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.neo4j.cluster.com.message.Message;
import org.neo4j.cluster.com.message.MessageProcessor;
import org.neo4j.cluster.com.message.MessageSource;
import org.neo4j.cluster.com.message.MessageType;
import org.neo4j.cluster.timeout.TimeoutStrategy;

public class Timeouts
implements MessageSource {
    private long now = 0L;
    private MessageProcessor receiver;
    private TimeoutStrategy timeoutStrategy;
    private Map<Object, Timeout> timeouts = new HashMap<Object, Timeout>();
    private List<Map.Entry<Object, Timeout>> triggeredTimeouts = new ArrayList<Map.Entry<Object, Timeout>>();

    public Timeouts(TimeoutStrategy timeoutStrategy) {
        this.timeoutStrategy = timeoutStrategy;
    }

    @Override
    public void addMessageProcessor(MessageProcessor messageProcessor) {
        if (this.receiver != null) {
            throw new UnsupportedOperationException("Timeouts does not yet support multiple message processors");
        }
        this.receiver = messageProcessor;
    }

    public void setTimeout(Object key, Message<? extends MessageType> timeoutMessage) {
        long timeoutAt = this.now + this.timeoutStrategy.timeoutFor(timeoutMessage);
        this.timeouts.put(key, new Timeout(timeoutAt, timeoutMessage));
    }

    public long getTimeoutFor(Message<? extends MessageType> timeoutMessage) {
        return this.timeoutStrategy.timeoutFor(timeoutMessage);
    }

    public Message<? extends MessageType> cancelTimeout(Object key) {
        Timeout timeout = this.timeouts.remove(key);
        if (timeout != null) {
            this.timeoutStrategy.timeoutCancelled(timeout.timeoutMessage);
            return timeout.getTimeoutMessage();
        }
        return null;
    }

    public void cancelAllTimeouts() {
        for (Timeout timeout : this.timeouts.values()) {
            this.timeoutStrategy.timeoutCancelled(timeout.getTimeoutMessage());
        }
        this.timeouts.clear();
    }

    public Map<Object, Timeout> getTimeouts() {
        return this.timeouts;
    }

    public Message<? extends MessageType> getTimeoutMessage(String timeoutName) {
        Timeout timeout = this.timeouts.get(timeoutName);
        if (timeout != null) {
            return timeout.getTimeoutMessage();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tick(long time) {
        Timeouts timeouts = this;
        synchronized (timeouts) {
            this.now = time;
            this.timeoutStrategy.tick(this.now);
            this.triggeredTimeouts.clear();
            for (Map.Entry<Object, Timeout> timeout : this.timeouts.entrySet()) {
                if (!timeout.getValue().checkTimeout(this.now)) continue;
                this.triggeredTimeouts.add(timeout);
            }
            for (Map.Entry<Object, Timeout> triggeredTimeout : this.triggeredTimeouts) {
                this.timeouts.remove(triggeredTimeout.getKey());
            }
        }
        for (Map.Entry entry : this.triggeredTimeouts) {
            ((Timeout)entry.getValue()).trigger(this.receiver);
        }
    }

    public class Timeout {
        private long timeout;
        private Message<? extends MessageType> timeoutMessage;

        public Timeout(long timeout, Message<? extends MessageType> timeoutMessage) {
            this.timeout = timeout;
            this.timeoutMessage = timeoutMessage;
        }

        public Message<? extends MessageType> getTimeoutMessage() {
            return this.timeoutMessage;
        }

        public boolean checkTimeout(long now) {
            if (now >= this.timeout) {
                Timeouts.this.timeoutStrategy.timeoutTriggered(this.timeoutMessage);
                return true;
            }
            return false;
        }

        public void trigger(MessageProcessor receiver) {
            receiver.process(this.timeoutMessage);
        }

        public String toString() {
            return this.timeout + ": " + this.timeoutMessage;
        }
    }
}

