/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cluster;

import java.time.Duration;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.neo4j.cluster.InstanceId;
import org.neo4j.configuration.Description;
import org.neo4j.configuration.Internal;
import org.neo4j.configuration.LoadableConfig;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.helpers.HostnamePort;
import org.neo4j.kernel.configuration.Settings;

@Description(value="Cluster configuration settings")
public class ClusterSettings
implements LoadableConfig {
    public static final Function<String, InstanceId> INSTANCE_ID = new Function<String, InstanceId>(){

        @Override
        public InstanceId apply(String value) {
            try {
                return new InstanceId(Integer.parseInt(value));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("not a valid integer value");
            }
        }

        public String toString() {
            return "an instance id, which has to be a valid integer";
        }
    };
    @Description(value="Configure the operating mode of the database -- 'SINGLE' for stand-alone operation, 'HA' for operating as a member in an HA cluster, 'ARBITER' for a cluster member with no database in an HA cluster, 'CORE' for operating as a core member of a Causal Cluster, or 'READ_REPLICA' for operating as a read replica member of a Causal Cluster.")
    public static final Setting<Mode> mode = Settings.setting((String)"dbms.mode", (Function)Settings.options(Mode.class), (String)Mode.SINGLE.name());
    @Description(value="Id for a cluster instance. Must be unique within the cluster.")
    public static final Setting<InstanceId> server_id = Settings.setting((String)"ha.server_id", INSTANCE_ID, (String)Settings.NO_DEFAULT);
    @Description(value="The name of a cluster.")
    @Internal
    public static final Setting<String> cluster_name = Settings.setting((String)"unsupported.ha.cluster_name", (Function)Settings.STRING, (String)"neo4j.ha", (BiFunction[])new BiFunction[]{Settings.illegalValueMessage((String)"must be a valid cluster name", (BiFunction)Settings.matches((String)".+"))});
    @Description(value="A comma-separated list of other members of the cluster to join.")
    public static final Setting<List<HostnamePort>> initial_hosts = Settings.setting((String)"ha.initial_hosts", (Function)Settings.list((String)",", (Function)Settings.HOSTNAME_PORT), (String)Settings.NO_DEFAULT);
    @Description(value="Host and port to bind the cluster management communication.")
    public static final Setting<HostnamePort> cluster_server = Settings.setting((String)"ha.host.coordination", (Function)Settings.HOSTNAME_PORT, (String)"0.0.0.0:5001-5099");
    @Description(value="Whether to allow this instance to create a cluster if unable to join.")
    public static final Setting<Boolean> allow_init_cluster = Settings.setting((String)"ha.allow_init_cluster", (Function)Settings.BOOLEAN, (String)"true");
    @Description(value="Default timeout used for clustering timeouts. Override  specific timeout settings with proper values if necessary. This value is the default value for the ha.heartbeat_interval, ha.paxos_timeout and ha.learn_timeout settings.")
    public static final Setting<Duration> default_timeout = Settings.setting((String)"ha.default_timeout", (Function)Settings.DURATION, (String)"5s");
    @Description(value="How often heartbeat messages should be sent. Defaults to ha.default_timeout.")
    public static final Setting<Duration> heartbeat_interval = Settings.setting((String)"ha.heartbeat_interval", (Function)Settings.DURATION, default_timeout);
    @Description(value="How long to wait for heartbeats from other instances before marking them as suspects for failure. This value reflects considerations of network latency, expected duration of garbage collection pauses and other factors that can delay message sending and processing. Larger values will result in more stable masters but also will result in longer waits before a failover in case of master failure. This value should not be set to less than twice the ha.heartbeat_interval value otherwise there is a high risk of frequent master switches and possibly branched data occurrence.")
    public static final Setting<Duration> heartbeat_timeout = Settings.setting((String)"ha.heartbeat_timeout", (Function)Settings.DURATION, (String)"40s");
    @Description(value="Timeout for broadcasting values in cluster. Must consider end-to-end duration of Paxos algorithm. This value is the default value for the ha.join_timeout and ha.leave_timeout settings.")
    public static final Setting<Duration> broadcast_timeout = Settings.setting((String)"ha.broadcast_timeout", (Function)Settings.DURATION, (String)"30s");
    @Description(value="Timeout for joining a cluster. Defaults to ha.broadcast_timeout. Note that if the timeout expires during cluster formation, the operator may have to restart the instance or instances.")
    public static final Setting<Duration> join_timeout = Settings.setting((String)"ha.join_timeout", (Function)Settings.DURATION, broadcast_timeout);
    @Description(value="Timeout for waiting for configuration from an existing cluster member during cluster join.")
    public static final Setting<Duration> configuration_timeout = Settings.setting((String)"ha.configuration_timeout", (Function)Settings.DURATION, (String)"1s");
    @Description(value="Timeout for waiting for cluster leave to finish. Defaults to ha.broadcast_timeout.")
    public static final Setting<Duration> leave_timeout = Settings.setting((String)"ha.leave_timeout", (Function)Settings.DURATION, broadcast_timeout);
    @Description(value="Default value for all Paxos timeouts. This setting controls the default value for the ha.phase1_timeout, ha.phase2_timeout and ha.election_timeout settings. If it is not given a value it defaults to ha.default_timeout and will implicitly change if ha.default_timeout changes. This is an advanced parameter which should only be changed if specifically advised by Neo4j Professional Services.")
    public static final Setting<Duration> paxos_timeout = Settings.setting((String)"ha.paxos_timeout", (Function)Settings.DURATION, default_timeout);
    @Description(value="Timeout for Paxos phase 1. If it is not given a value it defaults to ha.paxos_timeout and will implicitly change if ha.paxos_timeout changes. This is an advanced parameter which should only be changed if specifically advised by Neo4j Professional Services. ")
    public static final Setting<Duration> phase1_timeout = Settings.setting((String)"ha.phase1_timeout", (Function)Settings.DURATION, paxos_timeout);
    @Description(value="Timeout for Paxos phase 2. If it is not given a value it defaults to ha.paxos_timeout and will implicitly change if ha.paxos_timeout changes. This is an advanced parameter which should only be changed if specifically advised by Neo4j Professional Services. ")
    public static final Setting<Duration> phase2_timeout = Settings.setting((String)"ha.phase2_timeout", (Function)Settings.DURATION, paxos_timeout);
    @Description(value="Timeout for learning values. Defaults to ha.default_timeout.")
    public static final Setting<Duration> learn_timeout = Settings.setting((String)"ha.learn_timeout", (Function)Settings.DURATION, default_timeout);
    @Description(value="Timeout for waiting for other members to finish a role election. Defaults to ha.paxos_timeout.")
    public static final Setting<Duration> election_timeout = Settings.setting((String)"ha.election_timeout", (Function)Settings.DURATION, paxos_timeout);
    @Internal
    public static final Setting<String> instance_name = Settings.setting((String)"unsupported.ha.instance_name", (Function)Settings.STRING, (String)null);
    @Description(value="Maximum number of servers to involve when agreeing to membership changes. In very large clusters, the probability of half the cluster failing is low, but protecting against any arbitrary half failing is expensive. Therefore you may wish to set this parameter to a value less than the cluster size.")
    public static final Setting<Integer> max_acceptors = Settings.setting((String)"ha.max_acceptors", (Function)Settings.INTEGER, (String)"21", (BiFunction[])new BiFunction[]{Settings.min((Comparable)Integer.valueOf(1))});
    @Internal
    public static final Setting<Boolean> strict_initial_hosts = Settings.setting((String)"ha.strict_initial_hosts", (Function)Settings.BOOLEAN, (String)"false");

    public static enum Mode {
        SINGLE,
        HA,
        ARBITER,
        CORE,
        READ_REPLICA;

    }
}

