/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cluster;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.TimeUnit;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

public class DelayedDirectExecutor
extends AbstractExecutorService {
    private List<Runnable> runnables = new ArrayList<Runnable>();
    private final Log log;

    public DelayedDirectExecutor(LogProvider logProvider) {
        this.log = logProvider.getLog(this.getClass());
    }

    @Override
    public void shutdown() {
    }

    @Override
    public List<Runnable> shutdownNow() {
        return Collections.emptyList();
    }

    @Override
    public boolean isShutdown() {
        return false;
    }

    @Override
    public boolean isTerminated() {
        return false;
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return true;
    }

    @Override
    public synchronized void execute(Runnable command) {
        this.runnables.add(command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drain() {
        List<Runnable> currentRunnables;
        DelayedDirectExecutor delayedDirectExecutor = this;
        synchronized (delayedDirectExecutor) {
            currentRunnables = this.runnables;
            this.runnables = new ArrayList<Runnable>();
        }
        for (Runnable runnable : currentRunnables) {
            try {
                runnable.run();
            }
            catch (Throwable t) {
                this.log.error("Runnable failed", t);
            }
        }
    }
}

