/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cluster.client;

import java.net.URI;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.jboss.netty.logging.InternalLoggerFactory;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.cluster.ExecutorLifecycleAdapter;
import org.neo4j.cluster.InstanceId;
import org.neo4j.cluster.MultiPaxosServerFactory;
import org.neo4j.cluster.ProtocolServer;
import org.neo4j.cluster.StateMachines;
import org.neo4j.cluster.client.ClusterClient;
import org.neo4j.cluster.client.ClusterJoin;
import org.neo4j.cluster.com.NetworkReceiver;
import org.neo4j.cluster.com.NetworkSender;
import org.neo4j.cluster.logging.AsyncLogging;
import org.neo4j.cluster.logging.NettyLoggerFactory;
import org.neo4j.cluster.protocol.atomicbroadcast.AtomicBroadcastSerializer;
import org.neo4j.cluster.protocol.atomicbroadcast.ObjectStreamFactory;
import org.neo4j.cluster.protocol.atomicbroadcast.multipaxos.AtomicBroadcastMessage;
import org.neo4j.cluster.protocol.atomicbroadcast.multipaxos.InMemoryAcceptorInstanceStore;
import org.neo4j.cluster.protocol.atomicbroadcast.multipaxos.LearnerMessage;
import org.neo4j.cluster.protocol.atomicbroadcast.multipaxos.ProposerMessage;
import org.neo4j.cluster.protocol.cluster.ClusterConfiguration;
import org.neo4j.cluster.protocol.cluster.ClusterMessage;
import org.neo4j.cluster.protocol.election.ElectionCredentialsProvider;
import org.neo4j.cluster.protocol.election.ElectionMessage;
import org.neo4j.cluster.protocol.heartbeat.HeartbeatMessage;
import org.neo4j.cluster.statemachine.StateTransitionLogger;
import org.neo4j.cluster.timeout.FixedTimeoutStrategy;
import org.neo4j.cluster.timeout.MessageTimeoutStrategy;
import org.neo4j.function.Factory;
import org.neo4j.helpers.HostnamePort;
import org.neo4j.helpers.NamedThreadFactory;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.util.Dependencies;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.LogProvider;

public class ClusterClientModule {
    public final ClusterClient clusterClient;
    private final ProtocolServer server;

    public ClusterClientModule(LifeSupport life, Dependencies dependencies, Monitors monitors, final Config config, LogService logService, ElectionCredentialsProvider electionCredentialsProvider) {
        final LogProvider logging = AsyncLogging.provider(life, logService.getInternalLogProvider());
        InternalLoggerFactory.setDefaultFactory((InternalLoggerFactory)new NettyLoggerFactory(logging));
        MessageTimeoutStrategy timeoutStrategy = new MessageTimeoutStrategy(new FixedTimeoutStrategy(((Duration)config.get(ClusterSettings.default_timeout)).toMillis())).timeout(HeartbeatMessage.sendHeartbeat, ((Duration)config.get(ClusterSettings.heartbeat_interval)).toMillis()).timeout(HeartbeatMessage.timed_out, ((Duration)config.get(ClusterSettings.heartbeat_timeout)).toMillis()).timeout(AtomicBroadcastMessage.broadcastTimeout, ((Duration)config.get(ClusterSettings.broadcast_timeout)).toMillis()).timeout(LearnerMessage.learnTimedout, ((Duration)config.get(ClusterSettings.learn_timeout)).toMillis()).timeout(ProposerMessage.phase1Timeout, ((Duration)config.get(ClusterSettings.phase1_timeout)).toMillis()).timeout(ProposerMessage.phase2Timeout, ((Duration)config.get(ClusterSettings.phase2_timeout)).toMillis()).timeout(ClusterMessage.joiningTimeout, ((Duration)config.get(ClusterSettings.join_timeout)).toMillis()).timeout(ClusterMessage.configurationTimeout, ((Duration)config.get(ClusterSettings.configuration_timeout)).toMillis()).timeout(ClusterMessage.leaveTimedout, ((Duration)config.get(ClusterSettings.leave_timeout)).toMillis()).timeout(ElectionMessage.electionTimeout, ((Duration)config.get(ClusterSettings.election_timeout)).toMillis());
        MultiPaxosServerFactory protocolServerFactory = new MultiPaxosServerFactory(new ClusterConfiguration((String)config.get(ClusterSettings.cluster_name), logging, new String[0]), logging, (StateMachines.Monitor)monitors.newMonitor(StateMachines.Monitor.class, new String[0]));
        NetworkReceiver receiver = (NetworkReceiver)dependencies.satisfyDependency((Object)new NetworkReceiver((NetworkReceiver.Monitor)monitors.newMonitor(NetworkReceiver.Monitor.class, new String[0]), new NetworkReceiver.Configuration(){

            @Override
            public HostnamePort clusterServer() {
                return (HostnamePort)config.get(ClusterSettings.cluster_server);
            }

            @Override
            public int defaultPort() {
                return 5001;
            }

            @Override
            public String name() {
                return (String)config.get(ClusterSettings.instance_name);
            }
        }, logging));
        final ObjectStreamFactory objectInputStreamFactory = new ObjectStreamFactory();
        final ObjectStreamFactory objectOutputStreamFactory = new ObjectStreamFactory();
        receiver.addNetworkChannelsListener(new NetworkReceiver.NetworkChannelsListener(){
            private volatile StateTransitionLogger logger = null;

            @Override
            public void listeningAt(URI me) {
                ClusterClientModule.this.server.listeningAt(me);
                if (this.logger == null) {
                    this.logger = new StateTransitionLogger(logging, new AtomicBroadcastSerializer(objectInputStreamFactory, objectOutputStreamFactory));
                    ClusterClientModule.this.server.addStateTransitionListener(this.logger);
                }
            }

            @Override
            public void channelOpened(URI to) {
                logging.getLog(NetworkReceiver.class).info(to + " connected to me at " + ClusterClientModule.this.server.boundAt());
            }

            @Override
            public void channelClosed(URI to) {
                logging.getLog(NetworkReceiver.class).info(to + " disconnected from me at " + ClusterClientModule.this.server.boundAt());
            }
        });
        NetworkSender sender = (NetworkSender)dependencies.satisfyDependency((Object)new NetworkSender((NetworkSender.Monitor)monitors.newMonitor(NetworkSender.Monitor.class, new String[0]), new NetworkSender.Configuration(){

            @Override
            public int defaultPort() {
                return 5001;
            }

            @Override
            public int port() {
                return ((HostnamePort)config.get(ClusterSettings.cluster_server)).getPort();
            }
        }, receiver, logging));
        ExecutorLifecycleAdapter stateMachineExecutor = new ExecutorLifecycleAdapter((Factory<ExecutorService>)((Factory)() -> Executors.newSingleThreadExecutor((ThreadFactory)new NamedThreadFactory("State machine", (NamedThreadFactory.Monitor)monitors.newMonitor(NamedThreadFactory.Monitor.class, new String[0])))));
        InMemoryAcceptorInstanceStore acceptorInstanceStore = new InMemoryAcceptorInstanceStore();
        this.server = protocolServerFactory.newProtocolServer((InstanceId)config.get(ClusterSettings.server_id), timeoutStrategy, receiver, sender, acceptorInstanceStore, electionCredentialsProvider, stateMachineExecutor, objectInputStreamFactory, objectOutputStreamFactory, config);
        life.add((Lifecycle)sender);
        life.add((Lifecycle)stateMachineExecutor);
        life.add((Lifecycle)receiver);
        life.add((Lifecycle)new TimeoutTrigger(this.server, monitors));
        life.add((Lifecycle)new ClusterJoin(new ClusterJoin.Configuration(){

            @Override
            public List<HostnamePort> getInitialHosts() {
                return (List)config.get(ClusterSettings.initial_hosts);
            }

            @Override
            public String getClusterName() {
                return (String)config.get(ClusterSettings.cluster_name);
            }

            @Override
            public boolean isAllowedToCreateCluster() {
                return (Boolean)config.get(ClusterSettings.allow_init_cluster);
            }

            @Override
            public long getClusterJoinTimeout() {
                return ((Duration)config.get(ClusterSettings.join_timeout)).toMillis();
            }
        }, this.server, logService));
        this.clusterClient = (ClusterClient)dependencies.satisfyDependency((Object)new ClusterClient(life, this.server));
    }

    private static class TimeoutTrigger
    implements Lifecycle {
        private final ProtocolServer server;
        private final Monitors monitors;
        private ScheduledExecutorService scheduler;
        private ScheduledFuture<?> tickFuture;

        TimeoutTrigger(ProtocolServer server, Monitors monitors) {
            this.server = server;
            this.monitors = monitors;
        }

        public void init() {
            this.server.getTimeouts().tick(System.currentTimeMillis());
        }

        public void start() {
            this.scheduler = Executors.newSingleThreadScheduledExecutor((ThreadFactory)NamedThreadFactory.daemon((String)"timeout-clusterClient", (NamedThreadFactory.Monitor)((NamedThreadFactory.Monitor)this.monitors.newMonitor(NamedThreadFactory.Monitor.class, new String[0]))));
            this.tickFuture = this.scheduler.scheduleWithFixedDelay(() -> {
                long now = System.currentTimeMillis();
                this.server.getTimeouts().tick(now);
            }, 0L, 10L, TimeUnit.MILLISECONDS);
        }

        public void stop() {
            this.tickFuture.cancel(true);
            this.scheduler.shutdownNow();
        }

        public void shutdown() {
        }
    }
}

