/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cluster.com;

import java.net.ConnectException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelException;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.group.DefaultChannelGroup;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.jboss.netty.handler.codec.serialization.ObjectDecoder;
import org.jboss.netty.util.ThreadNameDeterminer;
import org.jboss.netty.util.ThreadRenamingRunnable;
import org.neo4j.cluster.com.message.Message;
import org.neo4j.cluster.com.message.MessageProcessor;
import org.neo4j.cluster.com.message.MessageSource;
import org.neo4j.helpers.HostnamePort;
import org.neo4j.helpers.Listeners;
import org.neo4j.helpers.NamedThreadFactory;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

public class NetworkReceiver
implements MessageSource,
Lifecycle {
    public static final String CLUSTER_SCHEME = "cluster";
    public static final String INADDR_ANY = "0.0.0.0";
    private ChannelGroup channels;
    private NioServerSocketChannelFactory nioChannelFactory;
    private ServerBootstrap serverBootstrap;
    private final Listeners<MessageProcessor> processors = new Listeners();
    private final Monitor monitor;
    private final Configuration config;
    private final Log msgLog;
    private final Map<URI, Channel> connections = new ConcurrentHashMap<URI, Channel>();
    private final Listeners<NetworkChannelsListener> listeners = new Listeners();
    volatile boolean bindingDetected = false;
    private volatile boolean paused;
    private int port;

    public NetworkReceiver(Monitor monitor, Configuration config, LogProvider logProvider) {
        this.monitor = monitor;
        this.config = config;
        this.msgLog = logProvider.getLog(this.getClass());
    }

    public void init() throws Throwable {
        ThreadRenamingRunnable.setThreadNameDeterminer((ThreadNameDeterminer)ThreadNameDeterminer.CURRENT);
    }

    public void start() throws Throwable {
        this.channels = new DefaultChannelGroup();
        this.nioChannelFactory = new NioServerSocketChannelFactory((Executor)Executors.newCachedThreadPool((ThreadFactory)NamedThreadFactory.daemon((String)"Cluster boss", (NamedThreadFactory.Monitor)this.monitor)), (Executor)Executors.newFixedThreadPool(2, (ThreadFactory)NamedThreadFactory.daemon((String)"Cluster worker", (NamedThreadFactory.Monitor)this.monitor)), 2);
        this.serverBootstrap = new ServerBootstrap((ChannelFactory)this.nioChannelFactory);
        this.serverBootstrap.setOption("child.tcpNoDelay", (Object)true);
        this.serverBootstrap.setPipelineFactory((ChannelPipelineFactory)new NetworkNodePipelineFactory());
        int[] ports = this.config.clusterServer().getPorts();
        int minPort = ports[0];
        int maxPort = ports.length == 2 ? ports[1] : minPort;
        this.port = this.listen(minPort, maxPort);
        this.msgLog.debug("Started NetworkReceiver at " + this.config.clusterServer().getHost() + ":" + this.port);
    }

    public void stop() throws Throwable {
        this.msgLog.debug("Shutting down NetworkReceiver at " + this.config.clusterServer().getHost() + ":" + this.port);
        this.channels.close().awaitUninterruptibly();
        this.serverBootstrap.releaseExternalResources();
        this.msgLog.debug("Shutting down NetworkReceiver complete");
    }

    public void shutdown() throws Throwable {
    }

    public void setPaused(boolean paused) {
        this.paused = paused;
    }

    private int listen(int minPort, int maxPort) throws URISyntaxException, ChannelException {
        ChannelException ex = null;
        for (int checkPort = minPort; checkPort <= maxPort; ++checkPort) {
            try {
                InetSocketAddress localAddress;
                String address = this.config.clusterServer().getHost();
                if (address == null || address.equals(INADDR_ANY)) {
                    localAddress = new InetSocketAddress(checkPort);
                } else {
                    localAddress = new InetSocketAddress(address, checkPort);
                    this.bindingDetected = true;
                }
                Channel listenChannel = this.serverBootstrap.bind((SocketAddress)localAddress);
                this.listeningAt(this.getURI(localAddress));
                this.channels.add((Object)listenChannel);
                return checkPort;
            }
            catch (ChannelException e) {
                ex = e;
                continue;
            }
        }
        this.nioChannelFactory.releaseExternalResources();
        throw ex;
    }

    @Override
    public void addMessageProcessor(MessageProcessor processor) {
        this.processors.add((Object)processor);
    }

    public void receive(Message message) {
        if (!this.paused) {
            for (MessageProcessor processor : this.processors) {
                try {
                    if (processor.process(message)) continue;
                    break;
                }
                catch (Exception exception) {
                }
            }
            this.monitor.processedMessage(message);
        }
    }

    URI getURI(InetSocketAddress socketAddress) {
        String uri;
        InetAddress address = socketAddress.getAddress();
        if (address instanceof Inet6Address) {
            uri = "cluster://" + NetworkReceiver.wrapAddressForIPv6Uri(address.getHostAddress()) + ":" + socketAddress.getPort();
        } else if (address instanceof Inet4Address) {
            uri = "cluster://" + address.getHostAddress() + ":" + socketAddress.getPort();
        } else {
            throw new IllegalArgumentException("Address type unknown");
        }
        if (this.config.name() != null) {
            uri = uri + "/?name=" + this.config.name();
        }
        return URI.create(uri);
    }

    public void listeningAt(URI me) {
        this.listeners.notify(listener -> listener.listeningAt(me));
    }

    protected void openedChannel(URI uri, Channel ctxChannel) {
        this.connections.put(uri, ctxChannel);
        this.listeners.notify(listener -> listener.channelOpened(uri));
    }

    protected void closedChannel(URI uri) {
        Channel channel = this.connections.remove(uri);
        if (channel != null) {
            channel.close();
        }
        this.listeners.notify(listener -> listener.channelClosed(uri));
    }

    public void addNetworkChannelsListener(NetworkChannelsListener listener) {
        this.listeners.add((Object)listener);
    }

    private static String wrapAddressForIPv6Uri(String address) {
        return "[" + address + "]";
    }

    class MessageReceiver
    extends SimpleChannelHandler {
        MessageReceiver() {
        }

        public void channelOpen(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
            Channel ctxChannel = ctx.getChannel();
            NetworkReceiver.this.openedChannel(NetworkReceiver.this.getURI((InetSocketAddress)ctxChannel.getRemoteAddress()), ctxChannel);
            NetworkReceiver.this.channels.add((Object)ctxChannel);
        }

        public void messageReceived(ChannelHandlerContext ctx, MessageEvent event) throws Exception {
            if (!NetworkReceiver.this.bindingDetected) {
                InetSocketAddress local = (InetSocketAddress)event.getChannel().getLocalAddress();
                NetworkReceiver.this.bindingDetected = true;
                NetworkReceiver.this.listeningAt(NetworkReceiver.this.getURI(local));
            }
            Message message = (Message)event.getMessage();
            InetSocketAddress remote = (InetSocketAddress)ctx.getChannel().getRemoteAddress();
            String remoteAddress = remote.getAddress().getHostAddress();
            URI fromHeader = URI.create(message.getHeader("from"));
            if (remote.getAddress() instanceof Inet6Address) {
                remoteAddress = NetworkReceiver.wrapAddressForIPv6Uri(remoteAddress);
            }
            fromHeader = URI.create(fromHeader.getScheme() + "://" + remoteAddress + ":" + fromHeader.getPort());
            message.setHeader("from", fromHeader.toASCIIString());
            NetworkReceiver.this.msgLog.debug("Received:" + message);
            NetworkReceiver.this.monitor.receivedMessage(message);
            NetworkReceiver.this.receive(message);
        }

        public void channelDisconnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
            NetworkReceiver.this.closedChannel(NetworkReceiver.this.getURI((InetSocketAddress)ctx.getChannel().getRemoteAddress()));
        }

        public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
            NetworkReceiver.this.closedChannel(NetworkReceiver.this.getURI((InetSocketAddress)ctx.getChannel().getRemoteAddress()));
            NetworkReceiver.this.channels.remove((Object)ctx.getChannel());
        }

        public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
            if (!(e.getCause() instanceof ConnectException)) {
                NetworkReceiver.this.msgLog.error("Receive exception:", e.getCause());
            }
        }
    }

    private class NetworkNodePipelineFactory
    implements ChannelPipelineFactory {
        private NetworkNodePipelineFactory() {
        }

        public ChannelPipeline getPipeline() throws Exception {
            ChannelPipeline pipeline = Channels.pipeline();
            pipeline.addLast("frameDecoder", (ChannelHandler)new ObjectDecoder(1024000, this.getClass().getClassLoader()));
            pipeline.addLast("serverHandler", (ChannelHandler)new MessageReceiver());
            return pipeline;
        }
    }

    public static interface NetworkChannelsListener {
        public void listeningAt(URI var1);

        public void channelOpened(URI var1);

        public void channelClosed(URI var1);
    }

    public static interface Configuration {
        public HostnamePort clusterServer();

        public int defaultPort();

        public String name();
    }

    public static interface Monitor
    extends NamedThreadFactory.Monitor {
        public void receivedMessage(Message var1);

        public void processedMessage(Message var1);
    }
}

