/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cluster.com.message;

import java.io.Serializable;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.cluster.com.message.MessageType;

public class Message<MESSAGETYPE extends MessageType>
implements Serializable {
    private static final long serialVersionUID = 7043669983188264476L;
    public static final String CONVERSATION_ID = "conversation-id";
    public static final String CREATED_BY = "created-by";
    public static final String TIMEOUT_COUNT = "timeout-count";
    public static final String FROM = "from";
    public static final String TO = "to";
    public static final String INSTANCE_ID = "instance-id";
    public static final String DISCOVERED = "discovered";
    private MESSAGETYPE messageType;
    private Object payload;
    private Map<String, String> headers = new HashMap<String, String>();

    public static <MESSAGETYPE extends MessageType> Message<MESSAGETYPE> to(MESSAGETYPE messageType, URI to) {
        return Message.to(messageType, to, null);
    }

    public static <MESSAGETYPE extends MessageType> Message<MESSAGETYPE> to(MESSAGETYPE messageType, URI to, Object payload) {
        return new Message<MESSAGETYPE>(messageType, payload).setHeader(TO, to.toString());
    }

    public static <MESSAGETYPE extends MessageType> Message<MESSAGETYPE> respond(MESSAGETYPE messageType, Message<?> message, Object payload) {
        return message.hasHeader(FROM) ? new Message<MESSAGETYPE>(messageType, payload).setHeader(TO, message.getHeader(FROM)) : Message.internal(messageType, payload);
    }

    public static <MESSAGETYPE extends MessageType> Message<MESSAGETYPE> internal(MESSAGETYPE message) {
        return Message.internal(message, null);
    }

    public static <MESSAGETYPE extends MessageType> Message<MESSAGETYPE> internal(MESSAGETYPE message, Object payload) {
        return new Message<MESSAGETYPE>(message, payload);
    }

    public static <MESSAGETYPE extends MessageType> Message<MESSAGETYPE> timeout(MESSAGETYPE message, Message<?> causedBy) {
        return Message.timeout(message, causedBy, null);
    }

    public static <MESSAGETYPE extends MessageType> Message<MESSAGETYPE> timeout(MESSAGETYPE message, Message<?> causedBy, Object payload) {
        Message<MESSAGETYPE> timeout = causedBy.copyHeadersTo(new Message<MESSAGETYPE>(message, payload), CONVERSATION_ID, CREATED_BY);
        int timeoutCount = 0;
        if (causedBy.hasHeader(TIMEOUT_COUNT)) {
            timeoutCount = Integer.parseInt(causedBy.getHeader(TIMEOUT_COUNT)) + 1;
        }
        timeout.setHeader(TIMEOUT_COUNT, "" + timeoutCount);
        return timeout;
    }

    protected Message(MESSAGETYPE messageType, Object payload) {
        this.messageType = messageType;
        this.payload = payload;
    }

    public MESSAGETYPE getMessageType() {
        return this.messageType;
    }

    public <T> T getPayload() {
        return (T)this.payload;
    }

    public Message<MESSAGETYPE> setHeader(String name, String value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Header %s may not be set to null", name));
        }
        this.headers.put(name, value);
        return this;
    }

    public boolean hasHeader(String name) {
        return this.headers.containsKey(name);
    }

    public boolean isInternal() {
        return !this.headers.containsKey(TO);
    }

    public String getHeader(String name) throws IllegalArgumentException {
        String value = this.getHeader(name, null);
        if (value == null) {
            throw new IllegalArgumentException("No such header:" + name);
        }
        return value;
    }

    public String getHeader(String name, String defaultValue) {
        String value = this.headers.get(name);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public <MSGTYPE extends MessageType> Message<MSGTYPE> copyHeadersTo(Message<MSGTYPE> message, String ... names) {
        if (names.length == 0) {
            for (Map.Entry<String, String> header : this.headers.entrySet()) {
                if (message.hasHeader(header.getKey())) continue;
                message.setHeader(header.getKey(), header.getValue());
            }
        } else {
            for (String name : names) {
                String value = this.headers.get(name);
                if (value == null || message.hasHeader(name)) continue;
                message.setHeader(name, value);
            }
        }
        return message;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Message message = (Message)o;
        if (this.headers != null ? !this.headers.equals(message.headers) : message.headers != null) {
            return false;
        }
        if (this.messageType != null ? !this.messageType.equals(message.messageType) : message.messageType != null) {
            return false;
        }
        return !(this.payload != null ? !this.payload.equals(message.payload) : message.payload != null);
    }

    public int hashCode() {
        int result = this.messageType != null ? this.messageType.hashCode() : 0;
        result = 31 * result + (this.payload != null ? this.payload.hashCode() : 0);
        result = 31 * result + (this.headers != null ? this.headers.hashCode() : 0);
        return result;
    }

    public String toString() {
        return this.messageType.name() + this.headers + (this.payload != null && this.payload instanceof String ? ": " + this.payload : "");
    }
}

