/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cluster.member.paxos;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import org.neo4j.cluster.InstanceId;
import org.neo4j.cluster.member.ClusterMemberEvents;
import org.neo4j.cluster.member.ClusterMemberListener;
import org.neo4j.cluster.member.paxos.MemberIsAvailable;
import org.neo4j.cluster.member.paxos.MemberIsUnavailable;
import org.neo4j.cluster.protocol.atomicbroadcast.AtomicBroadcast;
import org.neo4j.cluster.protocol.atomicbroadcast.AtomicBroadcastListener;
import org.neo4j.cluster.protocol.atomicbroadcast.AtomicBroadcastSerializer;
import org.neo4j.cluster.protocol.atomicbroadcast.ObjectInputStreamFactory;
import org.neo4j.cluster.protocol.atomicbroadcast.ObjectOutputStreamFactory;
import org.neo4j.cluster.protocol.atomicbroadcast.Payload;
import org.neo4j.cluster.protocol.cluster.Cluster;
import org.neo4j.cluster.protocol.cluster.ClusterConfiguration;
import org.neo4j.cluster.protocol.cluster.ClusterListener;
import org.neo4j.cluster.protocol.heartbeat.Heartbeat;
import org.neo4j.cluster.protocol.heartbeat.HeartbeatListener;
import org.neo4j.cluster.protocol.snapshot.Snapshot;
import org.neo4j.cluster.protocol.snapshot.SnapshotProvider;
import org.neo4j.function.Predicates;
import org.neo4j.helpers.Listeners;
import org.neo4j.helpers.NamedThreadFactory;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

public class PaxosClusterMemberEvents
implements ClusterMemberEvents,
Lifecycle {
    private Cluster cluster;
    private AtomicBroadcast atomicBroadcast;
    private Log log;
    protected AtomicBroadcastSerializer serializer;
    protected final Listeners<ClusterMemberListener> listeners = new Listeners();
    private ClusterMembersSnapshot clusterMembersSnapshot;
    private ClusterListener.Adapter clusterListener;
    private Snapshot snapshot;
    private AtomicBroadcastListener atomicBroadcastListener;
    private ExecutorService executor;
    private final Predicate<ClusterMembersSnapshot> snapshotValidator;
    private final Heartbeat heartbeat;
    private HeartbeatListenerImpl heartbeatListener;
    private ObjectInputStreamFactory lenientObjectInputStream;
    private ObjectOutputStreamFactory lenientObjectOutputStream;
    private final NamedThreadFactory.Monitor namedThreadFactoryMonitor;

    public PaxosClusterMemberEvents(Snapshot snapshot, Cluster cluster, Heartbeat heartbeat, AtomicBroadcast atomicBroadcast, LogProvider logProvider, Predicate<ClusterMembersSnapshot> validator, BiFunction<Iterable<MemberIsAvailable>, MemberIsAvailable, Iterable<MemberIsAvailable>> snapshotFilter, ObjectInputStreamFactory lenientObjectInputStream, ObjectOutputStreamFactory lenientObjectOutputStream, NamedThreadFactory.Monitor namedThreadFactoryMonitor) {
        this.snapshot = snapshot;
        this.cluster = cluster;
        this.heartbeat = heartbeat;
        this.atomicBroadcast = atomicBroadcast;
        this.lenientObjectInputStream = lenientObjectInputStream;
        this.lenientObjectOutputStream = lenientObjectOutputStream;
        this.namedThreadFactoryMonitor = namedThreadFactoryMonitor;
        this.log = logProvider.getLog(this.getClass());
        this.clusterListener = new ClusterListenerImpl();
        this.atomicBroadcastListener = new AtomicBroadcastListenerImpl();
        this.snapshotValidator = validator;
        this.clusterMembersSnapshot = new ClusterMembersSnapshot(snapshotFilter);
    }

    @Override
    public void addClusterMemberListener(ClusterMemberListener listener) {
        this.listeners.add((Object)listener);
    }

    @Override
    public void removeClusterMemberListener(ClusterMemberListener listener) {
        this.listeners.remove((Object)listener);
    }

    public void init() throws Throwable {
        this.serializer = new AtomicBroadcastSerializer(this.lenientObjectInputStream, this.lenientObjectOutputStream);
        this.cluster.addClusterListener(this.clusterListener);
        this.atomicBroadcast.addAtomicBroadcastListener(this.atomicBroadcastListener);
        this.snapshot.setSnapshotProvider(new HighAvailabilitySnapshotProvider());
        this.heartbeatListener = new HeartbeatListenerImpl();
        this.heartbeat.addHeartbeatListener(this.heartbeatListener);
        this.executor = Executors.newSingleThreadExecutor((ThreadFactory)new NamedThreadFactory("Paxos event notification", this.namedThreadFactoryMonitor));
    }

    public void start() throws Throwable {
    }

    public void stop() throws Throwable {
    }

    public void shutdown() throws Throwable {
        this.snapshot.setSnapshotProvider(null);
        if (this.executor != null) {
            this.executor.shutdown();
            this.executor = null;
        }
        this.cluster.removeClusterListener(this.clusterListener);
        this.atomicBroadcast.removeAtomicBroadcastListener(this.atomicBroadcastListener);
        this.heartbeat.removeHeartbeatListener(this.heartbeatListener);
    }

    private class HeartbeatListenerImpl
    implements HeartbeatListener {
        private HeartbeatListenerImpl() {
        }

        @Override
        public void failed(InstanceId server) {
            PaxosClusterMemberEvents.this.listeners.notify(listener -> listener.memberIsFailed(server));
        }

        @Override
        public void alive(InstanceId server) {
            PaxosClusterMemberEvents.this.listeners.notify(listener -> listener.memberIsAlive(server));
        }
    }

    private class AtomicBroadcastListenerImpl
    implements AtomicBroadcastListener {
        private AtomicBroadcastListenerImpl() {
        }

        @Override
        public void receive(Payload payload) {
            try {
                Object value = PaxosClusterMemberEvents.this.serializer.receive(payload);
                if (value instanceof MemberIsAvailable) {
                    MemberIsAvailable memberIsAvailable = (MemberIsAvailable)value;
                    PaxosClusterMemberEvents.this.clusterMembersSnapshot.availableMember(memberIsAvailable);
                    PaxosClusterMemberEvents.this.log.info("Snapshot:" + PaxosClusterMemberEvents.this.clusterMembersSnapshot.getCurrentAvailableMembers());
                    PaxosClusterMemberEvents.this.listeners.notify(listener -> listener.memberIsAvailable(memberIsAvailable.getRole(), memberIsAvailable.getInstanceId(), memberIsAvailable.getRoleUri(), memberIsAvailable.getStoreId()));
                } else if (value instanceof MemberIsUnavailable) {
                    MemberIsUnavailable memberIsUnavailable = (MemberIsUnavailable)value;
                    PaxosClusterMemberEvents.this.clusterMembersSnapshot.unavailableMember(memberIsUnavailable.getClusterUri(), memberIsUnavailable.getInstanceId(), memberIsUnavailable.getRole());
                    PaxosClusterMemberEvents.this.listeners.notify(listener -> listener.memberIsUnavailable(memberIsUnavailable.getRole(), memberIsUnavailable.getInstanceId()));
                }
            }
            catch (Throwable t) {
                PaxosClusterMemberEvents.this.log.error(String.format("Could not handle cluster member available message: %s (%d)", Base64.getEncoder().encodeToString(payload.getBuf()), payload.getLen()), t);
            }
        }
    }

    private class ClusterListenerImpl
    extends ClusterListener.Adapter {
        private ClusterListenerImpl() {
        }

        @Override
        public void enteredCluster(ClusterConfiguration clusterConfiguration) {
            for (Map.Entry<String, InstanceId> memberRoles : clusterConfiguration.getRoles().entrySet()) {
                this.elected(memberRoles.getKey(), memberRoles.getValue(), clusterConfiguration.getUriForId(memberRoles.getValue()));
            }
        }

        @Override
        public void elected(String role, InstanceId instanceId, URI electedMember) {
            if (role.equals("coordinator")) {
                PaxosClusterMemberEvents.this.listeners.notify(listener -> listener.coordinatorIsElected(instanceId));
            }
        }

        @Override
        public void leftCluster(InstanceId instanceId, URI member) {
            PaxosClusterMemberEvents.this.listeners.notify(listener -> {
                for (MemberIsAvailable memberIsAvailable : PaxosClusterMemberEvents.this.clusterMembersSnapshot.getCurrentAvailable(instanceId)) {
                    listener.memberIsUnavailable(memberIsAvailable.getRole(), instanceId);
                }
            });
            PaxosClusterMemberEvents.this.clusterMembersSnapshot.unavailableMember(instanceId);
        }
    }

    public static class ClusterMembersSnapshot
    implements Serializable {
        private static final long serialVersionUID = -4638991834604077187L;
        private BiFunction<Iterable<MemberIsAvailable>, MemberIsAvailable, Iterable<MemberIsAvailable>> nextSnapshotFunction;
        private Iterable<MemberIsAvailable> availableMembers = new ArrayList<MemberIsAvailable>();

        public ClusterMembersSnapshot(BiFunction<Iterable<MemberIsAvailable>, MemberIsAvailable, Iterable<MemberIsAvailable>> nextSnapshotFunction) {
            this.nextSnapshotFunction = nextSnapshotFunction;
        }

        public void availableMember(MemberIsAvailable memberIsAvailable) {
            this.availableMembers = Iterables.asList(this.nextSnapshotFunction.apply(this.availableMembers, memberIsAvailable));
        }

        public void unavailableMember(InstanceId member) {
            this.availableMembers = Iterables.asList((Iterable)Iterables.filter(item -> !item.getInstanceId().equals(member), this.availableMembers));
        }

        public void unavailableMember(URI member, InstanceId id, String role) {
            this.availableMembers = Iterables.asList((Iterable)Iterables.filter(item -> {
                boolean matchByUriOrId = item.getClusterUri().equals(member) || item.getInstanceId().equals(id);
                boolean matchByRole = item.getRole().equals(role);
                return !matchByUriOrId || !matchByRole;
            }, this.availableMembers));
        }

        public Iterable<MemberIsAvailable> getCurrentAvailableMembers() {
            return this.availableMembers;
        }

        public Iterable<MemberIsAvailable> getCurrentAvailable(InstanceId memberId) {
            return Iterables.asList((Iterable)Iterables.filter(item -> item.getInstanceId().equals(memberId), this.availableMembers));
        }
    }

    public static class UniqueRoleFilter
    implements BiFunction<Iterable<MemberIsAvailable>, MemberIsAvailable, Iterable<MemberIsAvailable>> {
        @Override
        public Iterable<MemberIsAvailable> apply(Iterable<MemberIsAvailable> previousSnapshot, MemberIsAvailable newMessage) {
            return Iterables.append((Object)newMessage, (Iterable)Iterables.filter(item -> Predicates.in((Object[])new InstanceId[]{newMessage.getInstanceId()}).negate().test(item.getInstanceId()), previousSnapshot));
        }
    }

    private class HighAvailabilitySnapshotProvider
    implements SnapshotProvider {
        private HighAvailabilitySnapshotProvider() {
        }

        @Override
        public void getState(ObjectOutputStream output) throws IOException {
            output.writeObject(PaxosClusterMemberEvents.this.clusterMembersSnapshot);
        }

        @Override
        public void setState(ObjectInputStream input) throws IOException, ClassNotFoundException {
            PaxosClusterMemberEvents.this.clusterMembersSnapshot = (ClusterMembersSnapshot)ClusterMembersSnapshot.class.cast(input.readObject());
            if (!PaxosClusterMemberEvents.this.snapshotValidator.test(PaxosClusterMemberEvents.this.clusterMembersSnapshot)) {
                PaxosClusterMemberEvents.this.executor.submit(() -> PaxosClusterMemberEvents.this.cluster.leave());
            } else {
                PaxosClusterMemberEvents.this.listeners.notify((Executor)PaxosClusterMemberEvents.this.executor, listener -> {
                    for (MemberIsAvailable memberIsAvailable : PaxosClusterMemberEvents.this.clusterMembersSnapshot.getCurrentAvailableMembers()) {
                        listener.memberIsAvailable(memberIsAvailable.getRole(), memberIsAvailable.getInstanceId(), memberIsAvailable.getRoleUri(), memberIsAvailable.getStoreId());
                    }
                });
            }
        }
    }
}

