/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cluster.protocol.atomicbroadcast;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.neo4j.cluster.protocol.atomicbroadcast.ObjectInputStreamFactory;
import org.neo4j.cluster.protocol.atomicbroadcast.ObjectOutputStreamFactory;
import org.neo4j.cluster.protocol.atomicbroadcast.ObjectStreamFactory;
import org.neo4j.cluster.protocol.atomicbroadcast.Payload;

public class AtomicBroadcastSerializer {
    private ObjectInputStreamFactory objectInputStreamFactory;
    private ObjectOutputStreamFactory objectOutputStreamFactory;

    public AtomicBroadcastSerializer() {
        this(new ObjectStreamFactory(), new ObjectStreamFactory());
    }

    public AtomicBroadcastSerializer(ObjectInputStreamFactory objectInputStreamFactory, ObjectOutputStreamFactory objectOutputStreamFactory) {
        this.objectInputStreamFactory = objectInputStreamFactory;
        this.objectOutputStreamFactory = objectOutputStreamFactory;
    }

    public Payload broadcast(Object value) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try (ObjectOutputStream oout = this.objectOutputStreamFactory.create(bout);){
            oout.writeObject(value);
        }
        byte[] bytes = bout.toByteArray();
        return new Payload(bytes, bytes.length);
    }

    public Object receive(Payload payload) throws IOException, ClassNotFoundException {
        ByteArrayInputStream in = new ByteArrayInputStream(payload.getBuf(), 0, payload.getLen());
        try (ObjectInputStream oin = this.objectInputStreamFactory.create(in);){
            Object object = oin.readObject();
            return object;
        }
    }
}

