/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cluster.protocol.atomicbroadcast.multipaxos;

import java.io.Serializable;
import org.neo4j.cluster.com.message.MessageType;
import org.neo4j.cluster.protocol.atomicbroadcast.AtomicBroadcastSerializer;
import org.neo4j.cluster.protocol.atomicbroadcast.ObjectStreamFactory;
import org.neo4j.cluster.protocol.atomicbroadcast.Payload;

public enum LearnerMessage implements MessageType
{
    join,
    leave,
    learn,
    learnRequest,
    learnFailed,
    learnTimedout,
    catchUp;


    public static class LearnFailedState
    implements Serializable {
        private static final long serialVersionUID = -6587635550010611226L;

        public String toString() {
            return "Learn failed";
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object obj) {
            return obj instanceof LearnFailedState;
        }
    }

    public static class LearnRequestState
    implements Serializable {
        private static final long serialVersionUID = -2577225800895578365L;

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            return this.getClass() == obj.getClass();
        }

        public int hashCode() {
            return 1;
        }

        public String toString() {
            return "Learn request";
        }
    }

    public static class LearnState
    implements Serializable {
        private static final long serialVersionUID = 3311287172384025589L;
        private Object value;

        public LearnState(Object value) {
            this.value = value;
        }

        public Object getValue() {
            return this.value;
        }

        public String toString() {
            if (this.value instanceof Payload) {
                try {
                    ObjectStreamFactory streamFactory = new ObjectStreamFactory();
                    return new AtomicBroadcastSerializer(streamFactory, streamFactory).receive((Payload)this.value).toString();
                }
                catch (Throwable e) {
                    return this.value.toString();
                }
            }
            return this.value.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LearnState that = (LearnState)o;
            return !(this.value != null ? !this.value.equals(that.value) : that.value != null);
        }

        public int hashCode() {
            return this.value != null ? this.value.hashCode() : 0;
        }
    }
}

