/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cluster.protocol.atomicbroadcast.multipaxos.context;

import java.net.URI;
import org.neo4j.cluster.InstanceId;
import org.neo4j.cluster.protocol.cluster.ClusterConfiguration;
import org.neo4j.logging.Log;

class CommonContextState {
    private URI boundAt;
    private long lastKnownLearnedInstanceInCluster = -1L;
    private InstanceId lastKnownAliveUpToDateInstance;
    private long nextInstanceId = 0L;
    private ClusterConfiguration configuration;
    private final int maxAcceptors;

    CommonContextState(ClusterConfiguration configuration, int maxAcceptors) {
        this.configuration = configuration;
        this.maxAcceptors = maxAcceptors;
    }

    private CommonContextState(URI boundAt, long lastKnownLearnedInstanceInCluster, long nextInstanceId, ClusterConfiguration configuration, int maxAcceptors) {
        this.boundAt = boundAt;
        this.lastKnownLearnedInstanceInCluster = lastKnownLearnedInstanceInCluster;
        this.nextInstanceId = nextInstanceId;
        this.configuration = configuration;
        this.maxAcceptors = maxAcceptors;
    }

    public URI boundAt() {
        return this.boundAt;
    }

    public void setBoundAt(InstanceId me, URI boundAt) {
        this.boundAt = boundAt;
        this.configuration.getMembers().put(me, boundAt);
    }

    public long lastKnownLearnedInstanceInCluster() {
        return this.lastKnownLearnedInstanceInCluster;
    }

    public void setLastKnownLearnedInstanceInCluster(long lastKnownLearnedInstanceInCluster, InstanceId instanceId) {
        if (this.lastKnownLearnedInstanceInCluster <= lastKnownLearnedInstanceInCluster) {
            this.lastKnownLearnedInstanceInCluster = lastKnownLearnedInstanceInCluster;
            if (instanceId != null) {
                this.lastKnownAliveUpToDateInstance = instanceId;
            }
        } else if (lastKnownLearnedInstanceInCluster == -1L) {
            this.lastKnownLearnedInstanceInCluster = -1L;
        }
    }

    public InstanceId getLastKnownAliveUpToDateInstance() {
        return this.lastKnownAliveUpToDateInstance;
    }

    public long nextInstanceId() {
        return this.nextInstanceId;
    }

    public void setNextInstanceId(long nextInstanceId) {
        this.nextInstanceId = nextInstanceId;
    }

    public long getAndIncrementInstanceId() {
        return this.nextInstanceId++;
    }

    public ClusterConfiguration configuration() {
        return this.configuration;
    }

    public void setConfiguration(ClusterConfiguration configuration) {
        this.configuration = configuration;
    }

    public int getMaxAcceptors() {
        return this.maxAcceptors;
    }

    public CommonContextState snapshot(Log log) {
        return new CommonContextState(this.boundAt, this.lastKnownLearnedInstanceInCluster, this.nextInstanceId, this.configuration.snapshot(log), this.maxAcceptors);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CommonContextState that = (CommonContextState)o;
        if (this.lastKnownLearnedInstanceInCluster != that.lastKnownLearnedInstanceInCluster) {
            return false;
        }
        if (this.nextInstanceId != that.nextInstanceId) {
            return false;
        }
        if (this.boundAt != null ? !this.boundAt.equals(that.boundAt) : that.boundAt != null) {
            return false;
        }
        return !(this.configuration != null ? !this.configuration.equals(that.configuration) : that.configuration != null);
    }

    public int hashCode() {
        int result = this.boundAt != null ? this.boundAt.hashCode() : 0;
        result = 31 * result + (int)(this.lastKnownLearnedInstanceInCluster ^ this.lastKnownLearnedInstanceInCluster >>> 32);
        result = 31 * result + (int)(this.nextInstanceId ^ this.nextInstanceId >>> 32);
        result = 31 * result + (this.configuration != null ? this.configuration.hashCode() : 0);
        return result;
    }
}

