/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cluster.protocol.atomicbroadcast.multipaxos.context;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.neo4j.cluster.InstanceId;
import org.neo4j.cluster.protocol.atomicbroadcast.multipaxos.DefaultWinnerStrategy;
import org.neo4j.cluster.protocol.atomicbroadcast.multipaxos.Vote;
import org.neo4j.cluster.protocol.atomicbroadcast.multipaxos.WinnerStrategy;
import org.neo4j.cluster.protocol.atomicbroadcast.multipaxos.context.AbstractContextImpl;
import org.neo4j.cluster.protocol.atomicbroadcast.multipaxos.context.ClusterContextImpl;
import org.neo4j.cluster.protocol.atomicbroadcast.multipaxos.context.CommonContextState;
import org.neo4j.cluster.protocol.atomicbroadcast.multipaxos.context.HeartbeatContextImpl;
import org.neo4j.cluster.protocol.cluster.ClusterContext;
import org.neo4j.cluster.protocol.cluster.ClusterMessage;
import org.neo4j.cluster.protocol.election.ElectionContext;
import org.neo4j.cluster.protocol.election.ElectionCredentials;
import org.neo4j.cluster.protocol.election.ElectionCredentialsProvider;
import org.neo4j.cluster.protocol.election.ElectionRole;
import org.neo4j.cluster.protocol.election.NotElectableElectionCredentials;
import org.neo4j.cluster.protocol.heartbeat.HeartbeatContext;
import org.neo4j.cluster.protocol.heartbeat.HeartbeatListener;
import org.neo4j.cluster.timeout.Timeouts;
import org.neo4j.cluster.util.Quorums;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.logging.LogProvider;

public class ElectionContextImpl
extends AbstractContextImpl
implements ElectionContext,
HeartbeatListener {
    private final ClusterContext clusterContext;
    private final HeartbeatContext heartbeatContext;
    private final List<ElectionRole> roles;
    private final Map<String, Election> elections;
    private final ElectionCredentialsProvider electionCredentialsProvider;

    ElectionContextImpl(InstanceId me, CommonContextState commonState, LogProvider logging, Timeouts timeouts, Iterable<ElectionRole> roles, ClusterContext clusterContext, HeartbeatContext heartbeatContext, ElectionCredentialsProvider electionCredentialsProvider) {
        super(me, commonState, logging, timeouts);
        this.electionCredentialsProvider = electionCredentialsProvider;
        this.roles = new ArrayList<ElectionRole>(Iterables.asList(roles));
        this.elections = new HashMap<String, Election>();
        this.clusterContext = clusterContext;
        this.heartbeatContext = heartbeatContext;
        heartbeatContext.addHeartbeatListener(this);
    }

    ElectionContextImpl(InstanceId me, CommonContextState commonState, LogProvider logging, Timeouts timeouts, ClusterContext clusterContext, HeartbeatContext heartbeatContext, List<ElectionRole> roles, Map<String, Election> elections, ElectionCredentialsProvider electionCredentialsProvider) {
        super(me, commonState, logging, timeouts);
        this.clusterContext = clusterContext;
        this.heartbeatContext = heartbeatContext;
        this.roles = roles;
        this.elections = elections;
        this.electionCredentialsProvider = electionCredentialsProvider;
        heartbeatContext.addHeartbeatListener(this);
    }

    @Override
    public void created() {
        for (ElectionRole role : this.roles) {
            this.clusterContext.elected(role.getName(), this.clusterContext.getMyId(), this.clusterContext.getMyId(), 1L);
        }
    }

    @Override
    public List<ElectionRole> getPossibleRoles() {
        return this.roles;
    }

    @Override
    public void nodeFailed(InstanceId node) {
        Iterable<String> rolesToDemote = this.getRoles(node);
        for (String role : rolesToDemote) {
            this.clusterContext.getConfiguration().removeElected(role);
        }
    }

    @Override
    public Iterable<String> getRoles(InstanceId server) {
        return this.clusterContext.getConfiguration().getRolesOf(server);
    }

    public ClusterContext getClusterContext() {
        return this.clusterContext;
    }

    public HeartbeatContext getHeartbeatContext() {
        return this.heartbeatContext;
    }

    @Override
    public boolean isElectionProcessInProgress(String role) {
        return this.elections.containsKey(role);
    }

    @Override
    public void startElectionProcess(String role) {
        this.clusterContext.getLog(this.getClass()).info("Doing elections for role " + role);
        if (!this.clusterContext.getMyId().equals(this.clusterContext.getLastElector())) {
            this.clusterContext.setLastElector(this.clusterContext.getMyId());
        }
        this.elections.put(role, new Election((WinnerStrategy)new DefaultWinnerStrategy(this.clusterContext)));
    }

    @Override
    public boolean voted(String role, InstanceId suggestedNode, ElectionCredentials suggestionCredentials, long electionVersion) {
        if (!this.isElectionProcessInProgress(role) || electionVersion != -1L && electionVersion < this.clusterContext.getLastElectorVersion()) {
            return false;
        }
        Map<InstanceId, Vote> votes = this.elections.get(role).getVotes();
        votes.put(suggestedNode, new Vote(suggestedNode, suggestionCredentials));
        return true;
    }

    @Override
    public InstanceId getElectionWinner(String role) {
        Election election = this.elections.get(role);
        if (election == null || election.getVotes().size() != this.getNeededVoteCount()) {
            return null;
        }
        this.elections.remove(role);
        return election.pickWinner();
    }

    @Override
    public ElectionCredentials getCredentialsForRole(String role) {
        return this.electionCredentialsProvider.getCredentials(role);
    }

    @Override
    public int getVoteCount(String role) {
        Election election = this.elections.get(role);
        if (election != null) {
            Map<InstanceId, Vote> voteList = election.getVotes();
            if (voteList == null) {
                return 0;
            }
            return voteList.size();
        }
        return 0;
    }

    @Override
    public int getNeededVoteCount() {
        return this.clusterContext.getConfiguration().getMembers().size() - this.heartbeatContext.getFailed().size();
    }

    @Override
    public void forgetElection(String role) {
        this.elections.remove(role);
        this.clusterContext.setLastElectorVersion(this.clusterContext.getLastElectorVersion() + 1L);
    }

    @Override
    public Iterable<String> getRolesRequiringElection() {
        return Iterables.filter(role -> this.clusterContext.getConfiguration().getElected((String)role) == null, (Iterable)Iterables.map(ElectionRole::getName, this.roles));
    }

    @Override
    public boolean electionOk() {
        int total = this.clusterContext.getConfiguration().getMembers().size();
        int available = total - this.heartbeatContext.getFailed().size();
        return Quorums.isQuorum(available, total);
    }

    @Override
    public boolean isInCluster() {
        return this.clusterContext.isInCluster();
    }

    @Override
    public Iterable<InstanceId> getAlive() {
        return this.heartbeatContext.getAlive();
    }

    @Override
    public InstanceId getMyId() {
        return this.clusterContext.getMyId();
    }

    @Override
    public boolean isElector() {
        List aliveInstances = Iterables.asList(this.getAlive());
        Collections.sort(aliveInstances);
        return aliveInstances.indexOf(this.getMyId()) == 0;
    }

    @Override
    public boolean isFailed(InstanceId key) {
        return this.heartbeatContext.getFailed().contains(key);
    }

    @Override
    public InstanceId getElected(String roleName) {
        return this.clusterContext.getConfiguration().getElected(roleName);
    }

    @Override
    public boolean hasCurrentlyElectedVoted(String role, InstanceId currentElected) {
        return this.elections.containsKey(role) && this.elections.get(role).getVotes().containsKey(currentElected);
    }

    @Override
    public Set<InstanceId> getFailed() {
        return this.heartbeatContext.getFailed();
    }

    public ElectionContextImpl snapshot(CommonContextState commonStateSnapshot, LogProvider logging, Timeouts timeouts, ClusterContextImpl snapshotClusterContext, HeartbeatContextImpl snapshotHeartbeatContext, ElectionCredentialsProvider credentialsProvider) {
        HashMap<String, Election> electionsSnapshot = new HashMap<String, Election>();
        for (Map.Entry<String, Election> election : this.elections.entrySet()) {
            electionsSnapshot.put(election.getKey(), election.getValue().snapshot());
        }
        return new ElectionContextImpl(this.me, commonStateSnapshot, logging, timeouts, snapshotClusterContext, snapshotHeartbeatContext, new ArrayList<ElectionRole>(this.roles), electionsSnapshot, credentialsProvider);
    }

    @Override
    public ClusterMessage.VersionedConfigurationStateChange newConfigurationStateChange() {
        ClusterMessage.VersionedConfigurationStateChange result = new ClusterMessage.VersionedConfigurationStateChange();
        result.setElector(this.clusterContext.getMyId());
        result.setVersion(this.clusterContext.getLastElectorVersion());
        return result;
    }

    @Override
    public ElectionContext.VoteRequest voteRequestForRole(ElectionRole role) {
        return new ElectionContext.VoteRequest(role.getName(), this.clusterContext.getLastElectorVersion());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ElectionContextImpl that = (ElectionContextImpl)o;
        if (this.elections != null ? !this.elections.equals(that.elections) : that.elections != null) {
            return false;
        }
        return !(this.roles != null ? !this.roles.equals(that.roles) : that.roles != null);
    }

    public int hashCode() {
        int result = this.roles != null ? this.roles.hashCode() : 0;
        result = 31 * result + (this.elections != null ? this.elections.hashCode() : 0);
        return result;
    }

    @Override
    public void failed(InstanceId server) {
        for (Map.Entry<String, Election> ongoingElection : this.elections.entrySet()) {
            ongoingElection.getValue().getVotes().remove(server);
        }
    }

    @Override
    public void alive(InstanceId server) {
    }

    public static List<Vote> removeBlankVotes(Collection<Vote> voteList) {
        return Iterables.asList((Iterable)Iterables.filter(item -> !(item.getCredentials() instanceof NotElectableElectionCredentials), voteList));
    }

    private static class Election {
        private final WinnerStrategy winnerStrategy;
        private final Map<InstanceId, Vote> votes;

        private Election(WinnerStrategy winnerStrategy) {
            this.winnerStrategy = winnerStrategy;
            this.votes = new HashMap<InstanceId, Vote>();
        }

        private Election(WinnerStrategy winnerStrategy, HashMap<InstanceId, Vote> votes) {
            this.votes = votes;
            this.winnerStrategy = winnerStrategy;
        }

        public Map<InstanceId, Vote> getVotes() {
            return this.votes;
        }

        public InstanceId pickWinner() {
            return this.winnerStrategy.pickWinner(this.votes.values());
        }

        public Election snapshot() {
            return new Election(this.winnerStrategy, new HashMap<InstanceId, Vote>(this.votes));
        }
    }
}

