/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cluster.protocol.heartbeat;

import java.net.URI;
import org.neo4j.cluster.InstanceId;
import org.neo4j.cluster.com.message.Message;
import org.neo4j.cluster.com.message.MessageHolder;
import org.neo4j.cluster.com.message.MessageType;
import org.neo4j.cluster.protocol.atomicbroadcast.multipaxos.LearnerMessage;
import org.neo4j.cluster.protocol.heartbeat.HeartbeatContext;
import org.neo4j.cluster.protocol.heartbeat.HeartbeatListener;
import org.neo4j.cluster.protocol.heartbeat.HeartbeatMessage;
import org.neo4j.cluster.statemachine.State;

public enum HeartbeatState implements State<HeartbeatContext, HeartbeatMessage>
{
    start{

        public HeartbeatState handle(HeartbeatContext context, Message<HeartbeatMessage> message, MessageHolder outgoing) throws Throwable {
            switch (message.getMessageType()) {
                case addHeartbeatListener: {
                    context.addHeartbeatListener((HeartbeatListener)message.getPayload());
                    break;
                }
                case removeHeartbeatListener: {
                    context.removeHeartbeatListener((HeartbeatListener)message.getPayload());
                    break;
                }
                case join: {
                    for (InstanceId instanceId : context.getOtherInstances()) {
                        context.setTimeout(HeartbeatMessage.i_am_alive + "-" + instanceId, Message.timeout(HeartbeatMessage.timed_out, message, instanceId));
                        outgoing.offer(Message.timeout(HeartbeatMessage.sendHeartbeat, message, instanceId));
                    }
                    return heartbeat;
                }
            }
            return this;
        }
    }
    ,
    heartbeat{

        public HeartbeatState handle(HeartbeatContext context, Message<HeartbeatMessage> message, MessageHolder outgoing) throws Throwable {
            switch (message.getMessageType()) {
                case i_am_alive: {
                    long lastLearned;
                    HeartbeatMessage.IAmAliveState state = (HeartbeatMessage.IAmAliveState)message.getPayload();
                    if (context.isMe(state.getServer()) || state.getServer() == null) break;
                    if (context.alive(state.getServer())) {
                        for (InstanceId aliveServer : context.getAlive()) {
                            if (aliveServer.equals(context.getMyId())) continue;
                            URI aliveServerUri = context.getUriForId(aliveServer);
                            outgoing.offer(Message.to(HeartbeatMessage.suspicions, aliveServerUri, new HeartbeatMessage.SuspicionsState(context.getSuspicionsFor(context.getMyId()))));
                        }
                    }
                    this.resetTimeout(context, message, state);
                    if (!message.hasHeader("last-learned") || (lastLearned = Long.parseLong(message.getHeader("last-learned"))) <= context.getLastKnownLearnedInstanceInCluster()) break;
                    Message<LearnerMessage> catchUpMessage = message.copyHeadersTo(Message.internal(LearnerMessage.catchUp, lastLearned), "from", "instance-id");
                    outgoing.offer(catchUpMessage);
                    break;
                }
                case timed_out: {
                    InstanceId server = (InstanceId)message.getPayload();
                    context.getLog(HeartbeatState.class).debug("Received timed out for server " + server);
                    if (context.getMembers().containsKey(server)) {
                        context.suspect(server);
                        context.setTimeout(HeartbeatMessage.i_am_alive + "-" + server, Message.timeout(HeartbeatMessage.timed_out, message, server));
                        for (InstanceId aliveServer : context.getAlive()) {
                            if (aliveServer.equals(context.getMyId())) continue;
                            URI sendTo = context.getUriForId(aliveServer);
                            outgoing.offer(Message.to(HeartbeatMessage.suspicions, sendTo, new HeartbeatMessage.SuspicionsState(context.getSuspicionsFor(context.getMyId()))));
                        }
                        break;
                    }
                    context.serverLeftCluster(server);
                    break;
                }
                case sendHeartbeat: {
                    InstanceId to = (InstanceId)message.getPayload();
                    if (context.isMe(to) || !context.getMembers().containsKey(to)) break;
                    URI toSendTo = context.getUriForId(to);
                    outgoing.offer(Message.to(HeartbeatMessage.i_am_alive, toSendTo, new HeartbeatMessage.IAmAliveState(context.getMyId())).setHeader("last-learned", context.getLastLearnedInstanceId() + ""));
                    context.setTimeout(HeartbeatMessage.sendHeartbeat + "-" + to, Message.timeout(HeartbeatMessage.sendHeartbeat, message, to));
                    break;
                }
                case reset_send_heartbeat: {
                    InstanceId to = (InstanceId)message.getPayload();
                    if (context.isMe(to)) break;
                    String timeoutName = HeartbeatMessage.sendHeartbeat + "-" + to;
                    context.cancelTimeout(timeoutName);
                    context.setTimeout(timeoutName, Message.timeout(HeartbeatMessage.sendHeartbeat, message, to));
                    break;
                }
                case suspicions: {
                    HeartbeatMessage.SuspicionsState suspicions = (HeartbeatMessage.SuspicionsState)message.getPayload();
                    InstanceId fromId = new InstanceId(Integer.parseInt(message.getHeader("instance-id")));
                    context.getLog(HeartbeatState.class).debug(String.format("Received suspicions as %s from %s", suspicions, fromId));
                    suspicions.getSuspicions().remove(context.getMyId());
                    context.suspicions(fromId, suspicions.getSuspicions());
                    break;
                }
                case leave: {
                    context.getLog(HeartbeatState.class).debug("Received leave");
                    return start;
                }
                case addHeartbeatListener: {
                    context.addHeartbeatListener((HeartbeatListener)message.getPayload());
                    break;
                }
                case removeHeartbeatListener: {
                    context.removeHeartbeatListener((HeartbeatListener)message.getPayload());
                    break;
                }
            }
            return this;
        }

        private void resetTimeout(HeartbeatContext context, Message<HeartbeatMessage> message, HeartbeatMessage.IAmAliveState state) {
            int timeoutCount;
            String key = HeartbeatMessage.i_am_alive + "-" + state.getServer();
            Message<? extends MessageType> oldTimeout = context.cancelTimeout(key);
            if (oldTimeout != null && oldTimeout.hasHeader("timeout-count") && (timeoutCount = Integer.parseInt(oldTimeout.getHeader("timeout-count"))) > 0) {
                long timeout = context.getTimeoutFor(oldTimeout);
                context.getLog(HeartbeatState.class).debug("Received " + state + " after missing " + timeoutCount + " (" + timeout * (long)timeoutCount + "ms)");
            }
            context.setTimeout(key, Message.timeout(HeartbeatMessage.timed_out, message, state.getServer()));
        }
    };

}

