/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cluster.statemachine;

import org.neo4j.cluster.com.message.Message;
import org.neo4j.cluster.com.message.MessageType;
import org.neo4j.cluster.statemachine.State;

public class StateTransition {
    private State<?, ?> oldState;
    private Message<? extends MessageType> message;
    private State<?, ?> newState;

    public StateTransition(State<?, ?> oldState, Message<? extends MessageType> message, State<?, ?> newState) {
        this.oldState = oldState;
        this.message = message;
        this.newState = newState;
    }

    public State<?, ?> getOldState() {
        return this.oldState;
    }

    public Message<? extends MessageType> getMessage() {
        return this.message;
    }

    public State<?, ?> getNewState() {
        return this.newState;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StateTransition that = (StateTransition)o;
        if (!this.message.equals(that.message)) {
            return false;
        }
        if (!this.newState.equals(that.newState)) {
            return false;
        }
        return this.oldState.equals(that.oldState);
    }

    public int hashCode() {
        int result = this.oldState.hashCode();
        result = 31 * result + this.message.hashCode();
        result = 31 * result + this.newState.hashCode();
        return result;
    }

    public String toString() {
        if (this.message.getPayload() instanceof String) {
            return this.getOldState().toString() + "-[" + this.getMessage().getMessageType() + ":" + this.getMessage().getPayload() + "]->" + this.getNewState().toString();
        }
        return this.getOldState().toString() + "-[" + this.getMessage().getMessageType() + "]->" + this.getNewState().toString();
    }
}

