/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.codegen;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.neo4j.codegen.ClassHandle;
import org.neo4j.codegen.CodeBlock;
import org.neo4j.codegen.ExpressionTemplate;
import org.neo4j.codegen.Lookup;
import org.neo4j.codegen.MethodDeclaration;
import org.neo4j.codegen.Parameter;
import org.neo4j.codegen.Statement;
import org.neo4j.codegen.TypeReference;

public class MethodTemplate {
    private final MethodDeclaration.Builder declaration;
    private final Parameter[] parameters;
    private final Statement[] statements;
    private final TypeReference returnType;
    private final String name;
    private final int modifiers;

    public static Builder method(Class<?> returnType, String name, Parameter ... parameters) {
        return MethodTemplate.method(TypeReference.typeReference(returnType), name, parameters);
    }

    public static Builder method(final TypeReference returnType, final String name, Parameter ... parameters) {
        try {
            return new Builder(parameters){

                @Override
                public MethodTemplate build() {
                    return MethodTemplate.buildMethod(this, returnType, name);
                }

                @Override
                MethodDeclaration.Builder declaration() {
                    return MethodDeclaration.method(returnType, name, this.parameters);
                }
            };
        }
        catch (IllegalArgumentException | NullPointerException e) {
            throw new IllegalArgumentException("Invalid signature for " + name + ": " + e.getMessage(), e);
        }
    }

    public static ConstructorBuilder constructor(Parameter ... parameters) {
        try {
            return new ConstructorBuilder(parameters);
        }
        catch (IllegalArgumentException | NullPointerException e) {
            throw new IllegalArgumentException("Invalid constructor signature: " + e.getMessage(), e);
        }
    }

    public TypeReference returnType() {
        return this.returnType;
    }

    public String name() {
        return this.name;
    }

    public int modifiers() {
        return this.modifiers;
    }

    public TypeReference[] parameterTypes() {
        if (this.parameters.length == 0) {
            return TypeReference.NO_TYPES;
        }
        TypeReference[] result = new TypeReference[this.parameters.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.parameters[i].type();
        }
        return result;
    }

    MethodDeclaration declaration(ClassHandle handle) {
        return this.declaration.build(handle);
    }

    void generate(CodeBlock generator) {
        for (Statement statement : this.statements) {
            statement.generate(generator);
        }
    }

    private static MethodTemplate buildMethod(Builder builder, TypeReference returnType, String name) {
        return new MethodTemplate(builder, returnType, name);
    }

    private static MethodTemplate buildConstructor(Builder builder) {
        return new MethodTemplate(builder, TypeReference.VOID, "<init>");
    }

    private MethodTemplate(Builder builder, TypeReference returnType, String name) {
        this.returnType = returnType;
        this.name = name;
        this.declaration = builder.declaration();
        this.parameters = builder.parameters;
        this.statements = builder.statements.toArray(new Statement[builder.statements.size()]);
        this.modifiers = builder.modifiers;
    }

    public static abstract class Builder {
        final Parameter[] parameters;
        private final Map<String, TypeReference> locals = new HashMap<String, TypeReference>();
        private final List<Statement> statements = new ArrayList<Statement>();
        private int modifiers = 1;

        Builder(Parameter[] parameters) {
            this.parameters = parameters == null || parameters.length == 0 ? Parameter.NO_PARAMETERS : (Parameter[])parameters.clone();
            for (int i = 0; i < this.parameters.length; ++i) {
                Parameter parameter = Objects.requireNonNull(this.parameters[i], "Parameter " + i);
                if (null == this.locals.put(parameter.name(), parameter.type())) continue;
                throw new IllegalArgumentException("Duplicate parameters named \"" + parameter.name() + "\".");
            }
        }

        public abstract MethodTemplate build();

        public Builder expression(ExpressionTemplate expression) {
            this.statements.add(Statement.expression(expression));
            return this;
        }

        public Builder put(ExpressionTemplate target, Class<?> fieldType, String fieldName, ExpressionTemplate expression) {
            return this.put(target, TypeReference.typeReference(fieldType), fieldName, expression);
        }

        public Builder put(ExpressionTemplate target, TypeReference fieldType, String fieldName, ExpressionTemplate expression) {
            this.statements.add(Statement.put(target, Lookup.field(fieldType, fieldName), expression));
            return this;
        }

        public Builder modifiers(int modifiers) {
            this.modifiers = modifiers;
            return this;
        }

        public Builder returns(ExpressionTemplate value) {
            this.statements.add(Statement.returns(value));
            return this;
        }

        abstract MethodDeclaration.Builder declaration();
    }

    public static class ConstructorBuilder
    extends Builder {
        ConstructorBuilder(Parameter[] parameters) {
            super(parameters);
        }

        public Builder invokeSuper() {
            return this.expression(ExpressionTemplate.invokeSuperConstructor(new ExpressionTemplate[0], TypeReference.NO_TYPES));
        }

        public Builder invokeSuper(ExpressionTemplate[] parameters, Class<?>[] parameterTypes) {
            TypeReference[] references = new TypeReference[parameterTypes.length];
            for (int i = 0; i < parameterTypes.length; ++i) {
                references[i] = TypeReference.typeReference(parameterTypes[i]);
            }
            return this.invokeSuper(parameters, references);
        }

        public Builder invokeSuper(ExpressionTemplate[] parameters, TypeReference[] parameterTypes) {
            return this.expression(ExpressionTemplate.invokeSuperConstructor(parameters, parameterTypes));
        }

        @Override
        public MethodTemplate build() {
            return MethodTemplate.buildConstructor(this);
        }

        @Override
        MethodDeclaration.Builder declaration() {
            return MethodDeclaration.constructor(this.parameters);
        }
    }
}

