/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.codegen;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import org.neo4j.codegen.MethodDeclaration;
import org.neo4j.codegen.MethodReference;
import org.neo4j.codegen.Parameter;
import org.neo4j.codegen.TypeReference;

public final class ByteCodeUtils {
    private ByteCodeUtils() {
        throw new UnsupportedOperationException();
    }

    public static String byteCodeName(TypeReference reference) {
        return ByteCodeUtils.className(reference).replace('.', '/');
    }

    public static String className(TypeReference reference) {
        StringBuilder builder = new StringBuilder();
        builder.append("[".repeat(Math.max(0, reference.arrayDepth())));
        if (reference.arrayDepth() > 0) {
            builder.append('L');
        }
        if (!reference.packageName().isEmpty()) {
            builder.append(reference.packageName()).append('.');
        }
        for (TypeReference parent : reference.declaringClasses()) {
            builder.append(parent.name()).append('$');
        }
        builder.append(reference.name());
        if (reference.isArray()) {
            builder.append(';');
        }
        return builder.toString();
    }

    public static String outerName(TypeReference reference) {
        if (!reference.isInnerClass()) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        if (!reference.packageName().isEmpty()) {
            builder.append(reference.packageName().replace('.', '/')).append('/');
        }
        builder.append(reference.simpleName());
        return builder.toString();
    }

    public static String typeName(TypeReference reference) {
        StringBuilder builder = new StringBuilder();
        ByteCodeUtils.internalType(builder, reference, false);
        return builder.toString();
    }

    public static String desc(MethodDeclaration declaration) {
        return ByteCodeUtils.internalDesc(declaration.erased(), false);
    }

    public static String desc(MethodReference reference) {
        StringBuilder builder = new StringBuilder();
        builder.append('(');
        for (TypeReference parameter : reference.parameters()) {
            ByteCodeUtils.internalType(builder, parameter, false);
        }
        builder.append(')');
        ByteCodeUtils.internalType(builder, reference.returns(), false);
        return builder.toString();
    }

    public static String signature(TypeReference reference) {
        if (!reference.isGeneric()) {
            return null;
        }
        return ByteCodeUtils.internalSignature(reference);
    }

    public static String signature(MethodDeclaration declaration) {
        if (!declaration.isGeneric()) {
            return null;
        }
        return ByteCodeUtils.internalDesc(declaration, true);
    }

    public static String[] exceptions(MethodDeclaration declaration) {
        List<TypeReference> throwsList = declaration.erased().throwsList();
        if (throwsList.isEmpty()) {
            return null;
        }
        return (String[])throwsList.stream().map(ByteCodeUtils::byteCodeName).toArray(String[]::new);
    }

    private static String internalDesc(MethodDeclaration declaration, boolean showErasure) {
        StringBuilder builder = new StringBuilder();
        List<MethodDeclaration.TypeParameter> typeParameters = declaration.typeParameters();
        if (showErasure && !typeParameters.isEmpty()) {
            builder.append('<');
            for (MethodDeclaration.TypeParameter typeParameter : typeParameters) {
                builder.append(typeParameter.name()).append(':');
                ByteCodeUtils.internalType(builder, typeParameter.extendsBound(), true);
            }
            builder.append('>');
        }
        builder.append('(');
        for (Parameter parameter : declaration.parameters()) {
            ByteCodeUtils.internalType(builder, parameter.type(), showErasure);
        }
        builder.append(')');
        ByteCodeUtils.internalType(builder, declaration.returnType(), showErasure);
        List<TypeReference> throwsList = declaration.throwsList();
        if (showErasure && throwsList.stream().anyMatch(TypeReference::isTypeParameter)) {
            builder.append('^');
            throwsList.forEach(t -> ByteCodeUtils.internalType(builder, t, false));
        }
        return builder.toString();
    }

    private static String internalSignature(TypeReference reference) {
        return ByteCodeUtils.internalType(new StringBuilder(), reference, true).toString();
    }

    private static StringBuilder internalType(StringBuilder builder, TypeReference reference, boolean showErasure) {
        String name = reference.name();
        builder.append("[".repeat(Math.max(0, reference.arrayDepth())));
        switch (name) {
            case "int": {
                builder.append('I');
                break;
            }
            case "long": {
                builder.append('J');
                break;
            }
            case "byte": {
                builder.append('B');
                break;
            }
            case "short": {
                builder.append('S');
                break;
            }
            case "char": {
                builder.append('C');
                break;
            }
            case "float": {
                builder.append('F');
                break;
            }
            case "double": {
                builder.append('D');
                break;
            }
            case "boolean": {
                builder.append('Z');
                break;
            }
            case "void": {
                builder.append('V');
                break;
            }
            default: {
                if (reference.isTypeParameter()) {
                    builder.append('T').append(name);
                } else {
                    builder.append('L');
                    String packageName = reference.packageName().replace('.', '/');
                    if (!packageName.isEmpty()) {
                        builder.append(packageName).append('/');
                    }
                    for (TypeReference parent : reference.declaringClasses()) {
                        builder.append(parent.name()).append('$');
                    }
                    builder.append(name.replace('.', '/'));
                }
                List<TypeReference> parameters = reference.parameters();
                if (showErasure && !parameters.isEmpty()) {
                    builder.append('<');
                    parameters.forEach(p -> ByteCodeUtils.internalType(builder, p, true));
                    builder.append('>');
                }
                builder.append(';');
            }
        }
        return builder;
    }

    public static void assertMethodExists(MethodReference methodReference) {
        Class<?> clazz;
        try {
            clazz = ByteCodeUtils.asClass(methodReference.owner());
        }
        catch (AssertionError e) {
            return;
        }
        try {
            TypeReference[] parameters = methodReference.parameters();
            if (methodReference.isConstructor()) {
                clazz.getDeclaredConstructor((Class[])Arrays.stream(parameters).map(ByteCodeUtils::asClass).toArray(Class[]::new));
            } else {
                Method method = clazz.getMethod(methodReference.name(), (Class[])Arrays.stream(parameters).map(ByteCodeUtils::asClass).toArray(Class[]::new));
                TypeReference returnType = TypeReference.typeReference(method.getReturnType());
                if (!methodReference.returns().name().equals(returnType.name())) {
                    throw new AssertionError((Object)String.format("Wrong return type of `%s::%s`, expected %s got %s", clazz.getSimpleName(), methodReference.name(), methodReference.returns(), returnType));
                }
            }
        }
        catch (NoSuchMethodException e) {
            CharSequence[] allMethods = (String[])Arrays.stream(clazz.getMethods()).map(Method::toString).toArray(String[]::new);
            String methodName = methodReference.returns().fullName() + " " + methodReference.name() + "(" + String.join((CharSequence)", ", (CharSequence[])Arrays.stream(methodReference.parameters()).map(TypeReference::fullName).toArray(String[]::new)) + ")";
            throw new AssertionError((Object)String.format("%s does not exists.%n Class %s has the following methods:%n%s", methodName, clazz.getCanonicalName(), String.join((CharSequence)String.format("%n    ", new Object[0]), allMethods)));
        }
    }

    private static Class<?> asClass(TypeReference typeReference) {
        try {
            String className;
            switch (className = typeReference.baseName()) {
                case "byte": {
                    return typeReference.isArray() ? byte[].class : Byte.TYPE;
                }
                case "char": {
                    return typeReference.isArray() ? char[].class : Character.TYPE;
                }
                case "short": {
                    return typeReference.isArray() ? short[].class : Short.TYPE;
                }
                case "int": {
                    return typeReference.isArray() ? int[].class : Integer.TYPE;
                }
                case "long": {
                    return typeReference.isArray() ? long[].class : Long.TYPE;
                }
                case "float": {
                    return typeReference.isArray() ? float[].class : Float.TYPE;
                }
                case "double": {
                    return typeReference.isArray() ? double[].class : Double.TYPE;
                }
                case "boolean": {
                    return typeReference.isArray() ? boolean[].class : Boolean.TYPE;
                }
            }
            return Class.forName(ByteCodeUtils.className(typeReference));
        }
        catch (ClassNotFoundException e) {
            throw new AssertionError((Object)String.format("%s does not exists", typeReference));
        }
    }
}

