/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collection.trackable;

import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.function.Consumer;
import java.util.function.LongFunction;
import org.eclipse.collections.api.block.procedure.primitive.LongObjectProcedure;
import org.eclipse.collections.api.iterator.LongIterator;
import org.neo4j.collection.trackable.AbstractHeapTrackingConcurrentHash;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.memory.MemoryTracker;

public final class HeapTrackingConcurrentLongObjectHashMap<V>
extends AbstractHeapTrackingConcurrentHash
implements AutoCloseable {
    private static final long SHALLOW_SIZE_THIS = HeapEstimator.shallowSizeOfInstance(HeapTrackingConcurrentLongObjectHashMap.class);
    private static final long SHALLOW_SIZE_WRAPPER = HeapEstimator.shallowSizeOfInstance(Entry.class);

    public static <V> HeapTrackingConcurrentLongObjectHashMap<V> newMap(MemoryTracker memoryTracker) {
        return HeapTrackingConcurrentLongObjectHashMap.newMap(memoryTracker, 16);
    }

    public static <V> HeapTrackingConcurrentLongObjectHashMap<V> newMap(MemoryTracker memoryTracker, int size) {
        memoryTracker.allocateHeap(SHALLOW_SIZE_THIS);
        return new HeapTrackingConcurrentLongObjectHashMap<V>(memoryTracker, size);
    }

    @Override
    public long sizeOfWrapperObject() {
        return SHALLOW_SIZE_WRAPPER;
    }

    private HeapTrackingConcurrentLongObjectHashMap(MemoryTracker memoryTracker, int initialCapacity) {
        super(memoryTracker, initialCapacity);
    }

    public V put(long key, V value) {
        int length;
        AtomicReferenceArray currentArray = this.table;
        int hash = this.hash(Long.hashCode(key));
        int index = HeapTrackingConcurrentLongObjectHashMap.indexFor(hash, length = currentArray.length());
        Object o = currentArray.get(index);
        if (o == null) {
            Entry<V> newEntry = new Entry<V>(key, value, null);
            this.addToSize(1);
            if (currentArray.compareAndSet(index, null, newEntry)) {
                return null;
            }
            this.addToSize(-1);
        }
        return this.slowPut(key, value, hash, currentArray);
    }

    private V slowPut(long key, V value, int hash, AtomicReferenceArray<Object> currentArray) {
        int length;
        Object o;
        block0: while (true) {
            int index;
            if ((o = HeapTrackingConcurrentLongObjectHashMap.getAtIndex(currentArray, index = HeapTrackingConcurrentLongObjectHashMap.indexFor(hash, length = currentArray.length()))) == RESIZED || o == RESIZING) {
                currentArray = this.helpWithResizeWhileCurrentIndex(currentArray, index);
                continue;
            }
            for (Object e = (Entry)o; e != null; e = ((Entry)e).getNext()) {
                if (((Entry)e).key != key) continue;
                Object oldValue = ((Entry)e).getValue();
                Entry<V> newEntry = new Entry<V>(((Entry)e).key, value, this.createReplacementChainForRemoval((Entry)o, (Entry<V>)e));
                if (!currentArray.compareAndSet(index, o, newEntry)) continue block0;
                return oldValue;
            }
            Entry<V> newEntry = new Entry<V>(key, value, (Entry)o);
            if (currentArray.compareAndSet(index, o, newEntry)) break;
        }
        this.incrementSizeAndPossiblyResize(currentArray, length, o);
        return null;
    }

    public V putIfAbsent(long key, V value) {
        int length;
        Object o;
        int hash = this.hash(Long.hashCode(key));
        AtomicReferenceArray<Object> currentArray = this.table;
        while (true) {
            int index;
            if ((o = HeapTrackingConcurrentLongObjectHashMap.getAtIndex(currentArray, index = HeapTrackingConcurrentLongObjectHashMap.indexFor(hash, length = currentArray.length()))) == RESIZED || o == RESIZING) {
                currentArray = this.helpWithResizeWhileCurrentIndex(currentArray, index);
                continue;
            }
            for (Object e = (Entry)o; e != null; e = ((Entry)e).getNext()) {
                if (((Entry)e).key != key) continue;
                return ((Entry)e).getValue();
            }
            Entry<V> newEntry = new Entry<V>(key, value, (Entry)o);
            if (currentArray.compareAndSet(index, o, newEntry)) break;
        }
        this.incrementSizeAndPossiblyResize(currentArray, length, o);
        return null;
    }

    public V computeIfAbsent(long key, LongFunction<V> mappingFunction) {
        int length;
        int index;
        Object o;
        int hash = this.hash(Long.hashCode(key));
        AtomicReferenceArray<Object> currentArray = this.table;
        while (true) {
            if ((o = HeapTrackingConcurrentLongObjectHashMap.getAtIndex(currentArray, index = HeapTrackingConcurrentLongObjectHashMap.indexFor(hash, length = currentArray.length()))) == RESIZED || o == RESIZING) {
                currentArray = this.helpWithResizeWhileCurrentIndex(currentArray, index);
                continue;
            }
            for (Object e = (Entry)o; e != null; e = ((Entry)e).getNext()) {
                if (((Entry)e).key != key) continue;
                return ((Entry)e).getValue();
            }
            if (currentArray.compareAndSet(index, o, RESERVED)) break;
        }
        V newValue = mappingFunction.apply(key);
        Entry<V> newEntry = new Entry<V>(key, newValue, (Entry)o);
        currentArray.set(index, newEntry);
        this.incrementSizeAndPossiblyResize(currentArray, length, o);
        return newValue;
    }

    @Override
    void transfer(AtomicReferenceArray<Object> src, AbstractHeapTrackingConcurrentHash.ResizeContainer resizeContainer) {
        AtomicReferenceArray<Object> dest = resizeContainer.nextArray;
        int j = 0;
        while (j < src.length() - 1) {
            Object o = HeapTrackingConcurrentLongObjectHashMap.getAtIndex(src, j);
            if (o == null) {
                if (!src.compareAndSet(j, null, RESIZED)) continue;
                ++j;
                continue;
            }
            if (o == RESIZED || o == RESIZING) {
                j = (j & -AbstractHeapTrackingConcurrentHash.ResizeContainer.QUEUE_INCREMENT) + AbstractHeapTrackingConcurrentHash.ResizeContainer.QUEUE_INCREMENT;
                if (resizeContainer.resizers.get() != 1) continue;
                break;
            }
            if (!src.compareAndSet(j, o, RESIZING)) continue;
            for (Object e = (Entry)o; e != null; e = ((Entry)e).getNext()) {
                this.unconditionalCopy(dest, (Entry<V>)e);
            }
            src.set(j, RESIZED);
            ++j;
        }
        resizeContainer.decrementResizerAndNotify();
        resizeContainer.waitForAllResizers();
    }

    @Override
    void reverseTransfer(AtomicReferenceArray<Object> src, AbstractHeapTrackingConcurrentHash.ResizeContainer resizeContainer) {
        AtomicReferenceArray<Object> dest = resizeContainer.nextArray;
        while (resizeContainer.getQueuePosition() > 0) {
            int start = resizeContainer.subtractAndGetQueuePosition();
            int end = start + AbstractHeapTrackingConcurrentHash.ResizeContainer.QUEUE_INCREMENT;
            if (end <= 0) continue;
            if (start < 0) {
                start = 0;
            }
            int j = end - 1;
            while (j >= start) {
                Object o = HeapTrackingConcurrentLongObjectHashMap.getAtIndex(src, j);
                if (o == null) {
                    if (!src.compareAndSet(j, null, RESIZED)) continue;
                    --j;
                    continue;
                }
                if (o == RESIZED || o == RESIZING) {
                    resizeContainer.zeroOutQueuePosition();
                    return;
                }
                if (!src.compareAndSet(j, o, RESIZING)) continue;
                for (Object e = (Entry)o; e != null; e = ((Entry)e).getNext()) {
                    this.unconditionalCopy(dest, (Entry<V>)e);
                }
                src.set(j, RESIZED);
                --j;
            }
        }
    }

    private void unconditionalCopy(AtomicReferenceArray<Object> dest, Entry<V> toCopyEntry) {
        int hash = this.hash(toCopyEntry.key);
        AtomicReferenceArray<Object> currentArray = dest;
        while (true) {
            int length;
            int index;
            Object o;
            if ((o = HeapTrackingConcurrentLongObjectHashMap.getAtIndex(currentArray, index = HeapTrackingConcurrentLongObjectHashMap.indexFor(hash, length = currentArray.length()))) == RESIZED || o == RESIZING) {
                currentArray = ((AbstractHeapTrackingConcurrentHash.ResizeContainer)currentArray.get((int)(length - 1))).nextArray;
                continue;
            }
            Entry<V> newEntry = o == null ? (toCopyEntry.getNext() == null ? toCopyEntry : new Entry<V>(toCopyEntry.key, toCopyEntry.getValue())) : new Entry<V>(toCopyEntry.key, toCopyEntry.getValue(), (Entry)o);
            if (currentArray.compareAndSet(index, o, newEntry)) break;
        }
    }

    /*
     * Unable to fully structure code
     */
    public boolean remove(long key, Object value) {
        hash = this.hash(Long.hashCode(key));
        currentArray = this.table;
        block0: while (true) {
            if ((o = HeapTrackingConcurrentLongObjectHashMap.getAtIndex(currentArray, index = HeapTrackingConcurrentLongObjectHashMap.indexFor(hash, length = currentArray.length()))) == HeapTrackingConcurrentLongObjectHashMap.RESIZED || o == HeapTrackingConcurrentLongObjectHashMap.RESIZING) {
                currentArray = this.helpWithResizeWhileCurrentIndex(currentArray, index);
                continue;
            }
            for (e = (Entry)o; e != null; e = e.getNext()) {
                if (e.key != key || !Objects.equals(e.getValue(), value)) continue;
                replacement = this.createReplacementChainForRemoval((Entry)o, (Entry<V>)e);
                if (currentArray.compareAndSet(index, o, replacement)) ** break;
                continue block0;
                this.addToSize(-1);
                return true;
            }
            break;
        }
        return false;
    }

    public boolean containsKey(long key) {
        return this.getEntry(key) != null;
    }

    public boolean containsValue(Object value) {
        AbstractHeapTrackingConcurrentHash.ResizeContainer resizeContainer;
        AtomicReferenceArray<Object> currentArray = this.table;
        do {
            resizeContainer = null;
            for (int i = 0; i < currentArray.length() - 1; ++i) {
                Object o = HeapTrackingConcurrentLongObjectHashMap.getAtIndex(currentArray, i);
                if (o == RESIZED || o == RESIZING) {
                    resizeContainer = (AbstractHeapTrackingConcurrentHash.ResizeContainer)currentArray.get(currentArray.length() - 1);
                    continue;
                }
                if (o == null) continue;
                for (Object e = (Entry)o; e != null; e = ((Entry)e).getNext()) {
                    Object v = ((Entry)e).getValue();
                    if (!Objects.equals(v, value)) continue;
                    return true;
                }
            }
            if (resizeContainer == null) continue;
            if (resizeContainer.isNotDone()) {
                this.helpWithResize(currentArray);
                resizeContainer.waitForAllResizers();
            }
            currentArray = resizeContainer.nextArray;
        } while (resizeContainer != null);
        return false;
    }

    public V get(long key) {
        AtomicReferenceArray currentArray = this.table;
        int hash = this.hash(Long.hashCode(key));
        int index = HeapTrackingConcurrentLongObjectHashMap.indexFor(hash, currentArray.length());
        Object o = HeapTrackingConcurrentLongObjectHashMap.getAtIndex(currentArray, index);
        if (o == RESIZED || o == RESIZING) {
            return this.slowGet(key, hash, currentArray);
        }
        for (Object e = (Entry)o; e != null; e = ((Entry)e).getNext()) {
            if (((Entry)e).key != key) continue;
            return ((Entry)e).value;
        }
        return null;
    }

    private V slowGet(long key, int hash, AtomicReferenceArray<Object> currentArray) {
        int length;
        int index;
        Object o;
        while ((o = HeapTrackingConcurrentLongObjectHashMap.getAtIndex(currentArray, index = HeapTrackingConcurrentLongObjectHashMap.indexFor(hash, length = currentArray.length()))) == RESIZED || o == RESIZING) {
            currentArray = this.helpWithResizeWhileCurrentIndex(currentArray, index);
        }
        for (Object e = (Entry)o; e != null; e = ((Entry)e).getNext()) {
            if (((Entry)e).key != key) continue;
            return ((Entry)e).getValue();
        }
        return null;
    }

    public LongIterator keys() {
        return new KeyIterator(this);
    }

    public Iterator<V> values() {
        return new ValueIterator(this);
    }

    public void forEach(LongObjectProcedure<? super V> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        EntryIterator iterator = new EntryIterator(this);
        while (iterator.hasNext()) {
            Object next = iterator.next();
            action.value(((Entry)next).key, ((Entry)next).value);
        }
    }

    public void forEachValue(Consumer<? super V> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        Iterator<V> values = this.values();
        while (values.hasNext()) {
            action.accept(values.next());
        }
    }

    private Entry<V> getEntry(long key) {
        int length;
        int index;
        Object o;
        int hash = this.hash(Long.hashCode(key));
        AtomicReferenceArray<Object> currentArray = this.table;
        while ((o = HeapTrackingConcurrentLongObjectHashMap.getAtIndex(currentArray, index = HeapTrackingConcurrentLongObjectHashMap.indexFor(hash, length = currentArray.length()))) == RESIZED || o == RESIZING) {
            currentArray = this.helpWithResizeWhileCurrentIndex(currentArray, index);
        }
        for (Object e = (Entry)o; e != null; e = ((Entry)e).getNext()) {
            if (((Entry)e).key != key) continue;
            return e;
        }
        return null;
    }

    public void clear() {
        AbstractHeapTrackingConcurrentHash.ResizeContainer resizeContainer;
        AtomicReferenceArray<Object> currentArray = this.table;
        do {
            resizeContainer = null;
            for (int i = 0; i < currentArray.length() - 1; ++i) {
                Object o = HeapTrackingConcurrentLongObjectHashMap.getAtIndex(currentArray, i);
                if (o == RESIZED || o == RESIZING) {
                    resizeContainer = (AbstractHeapTrackingConcurrentHash.ResizeContainer)currentArray.get(currentArray.length() - 1);
                    continue;
                }
                if (o == null) continue;
                if (!currentArray.compareAndSet(i, o, null)) continue;
                int removedEntries = 0;
                for (Object e = (Entry)o; e != null; e = ((Entry)e).getNext()) {
                    ++removedEntries;
                }
                this.addToSize(-removedEntries);
            }
            if (resizeContainer == null) continue;
            if (resizeContainer.isNotDone()) {
                this.helpWithResize(currentArray);
                resizeContainer.waitForAllResizers();
            }
            currentArray = resizeContainer.nextArray;
        } while (resizeContainer != null);
    }

    public boolean replace(long key, V oldValue, V newValue) {
        int length;
        AtomicReferenceArray currentArray = this.table;
        int hash = this.hash(Long.hashCode(key));
        int index = HeapTrackingConcurrentLongObjectHashMap.indexFor(hash, length = currentArray.length());
        Object o = HeapTrackingConcurrentLongObjectHashMap.getAtIndex(currentArray, index);
        if (o == RESIZED || o == RESIZING) {
            return this.slowReplace(key, oldValue, newValue, hash, currentArray);
        }
        for (Object e = (Entry)o; e != null; e = ((Entry)e).getNext()) {
            if (((Entry)e).key != key) continue;
            if (oldValue == ((Entry)e).getValue() || oldValue != null && oldValue.equals(((Entry)e).getValue())) {
                Entry<V> replacement = this.createReplacementChainForRemoval((Entry)o, (Entry<V>)e);
                Entry<V> newEntry = new Entry<V>(key, newValue, replacement);
                return currentArray.compareAndSet(index, o, newEntry) || this.slowReplace(key, oldValue, newValue, hash, currentArray);
            }
            return false;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean slowReplace(long key, V oldValue, V newValue, int hash, AtomicReferenceArray<Object> currentArray) {
        block0: while (true) {
            int length;
            int index;
            Object o;
            if ((o = HeapTrackingConcurrentLongObjectHashMap.getAtIndex(currentArray, index = HeapTrackingConcurrentLongObjectHashMap.indexFor(hash, length = currentArray.length()))) == RESIZED || o == RESIZING) {
                currentArray = this.helpWithResizeWhileCurrentIndex(currentArray, index);
                continue;
            }
            for (Object e = (Entry)o; e != null; e = ((Entry)e).getNext()) {
                if (((Entry)e).key != key) continue;
                if (oldValue != ((Entry)e).getValue() && (oldValue == null || !oldValue.equals(((Entry)e).getValue()))) return false;
                Entry<V> replacement = this.createReplacementChainForRemoval((Entry)o, (Entry<V>)e);
                Entry<V> newEntry = new Entry<V>(key, newValue, replacement);
                if (currentArray.compareAndSet(index, o, newEntry)) return true;
                continue block0;
            }
            break;
        }
        return false;
    }

    public V replace(long key, V value) {
        int length;
        AtomicReferenceArray currentArray = this.table;
        int hash = this.hash(Long.hashCode(key));
        int index = HeapTrackingConcurrentLongObjectHashMap.indexFor(hash, length = currentArray.length());
        Object o = currentArray.get(index);
        if (o == null) {
            return null;
        }
        return this.slowReplace(key, value, hash, currentArray);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private V slowReplace(long key, V value, int hash, AtomicReferenceArray<Object> currentArray) {
        block0: while (true) {
            int length;
            int index;
            Object o;
            if ((o = HeapTrackingConcurrentLongObjectHashMap.getAtIndex(currentArray, index = HeapTrackingConcurrentLongObjectHashMap.indexFor(hash, length = currentArray.length()))) == RESIZED || o == RESIZING) {
                currentArray = this.helpWithResizeWhileCurrentIndex(currentArray, index);
                continue;
            }
            for (Object e = (Entry)o; e != null; e = ((Entry)e).getNext()) {
                if (((Entry)e).key != key) continue;
                Object oldValue = ((Entry)e).getValue();
                Entry<V> newEntry = new Entry<V>(((Entry)e).key, value, this.createReplacementChainForRemoval((Entry)o, (Entry<V>)e));
                if (currentArray.compareAndSet(index, o, newEntry)) return oldValue;
                continue block0;
            }
            break;
        }
        return null;
    }

    public V remove(long key) {
        int length;
        AtomicReferenceArray currentArray = this.table;
        int hash = this.hash(Long.hashCode(key));
        int index = HeapTrackingConcurrentLongObjectHashMap.indexFor(hash, length = currentArray.length());
        Object o = HeapTrackingConcurrentLongObjectHashMap.getAtIndex(currentArray, index);
        if (o == RESIZED || o == RESIZING) {
            return this.slowRemove(key, hash, currentArray);
        }
        for (Object e = (Entry)o; e != null; e = ((Entry)e).getNext()) {
            if (((Entry)e).key != key) continue;
            Entry<V> replacement = this.createReplacementChainForRemoval((Entry)o, (Entry<V>)e);
            if (currentArray.compareAndSet(index, o, replacement)) {
                this.addToSize(-1);
                return ((Entry)e).getValue();
            }
            return this.slowRemove(key, hash, currentArray);
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private V slowRemove(long key, int hash, AtomicReferenceArray<Object> currentArray) {
        block0: while (true) {
            if ((o = HeapTrackingConcurrentLongObjectHashMap.getAtIndex(currentArray, index = HeapTrackingConcurrentLongObjectHashMap.indexFor(hash, length = currentArray.length()))) == HeapTrackingConcurrentLongObjectHashMap.RESIZED || o == HeapTrackingConcurrentLongObjectHashMap.RESIZING) {
                currentArray = this.helpWithResizeWhileCurrentIndex(currentArray, index);
                continue;
            }
            for (e = (Entry)o; e != null; e = e.getNext()) {
                if (e.key != key) continue;
                replacement = this.createReplacementChainForRemoval((Entry)o, (Entry<V>)e);
                if (currentArray.compareAndSet(index, o, replacement)) ** break;
                continue block0;
                this.addToSize(-1);
                return e.getValue();
            }
            break;
        }
        return null;
    }

    private Entry<V> createReplacementChainForRemoval(Entry<V> original, Entry<V> toRemove) {
        if (original == toRemove) {
            return original.getNext();
        }
        Entry replacement = null;
        for (Object e = original; e != null; e = ((Entry)e).getNext()) {
            if (e == toRemove) continue;
            replacement = new Entry(((Entry)e).key, ((Entry)e).getValue(), replacement);
        }
        return replacement;
    }

    public int hashCode() {
        int h = 0;
        AtomicReferenceArray currentArray = this.table;
        for (int i = 0; i < currentArray.length() - 1; ++i) {
            Object o = HeapTrackingConcurrentLongObjectHashMap.getAtIndex(currentArray, i);
            if (o == RESIZED || o == RESIZING) {
                throw new ConcurrentModificationException("can't compute hashcode while resizing!");
            }
            for (Object e = (Entry)o; e != null; e = ((Entry)e).getNext()) {
                long key = ((Entry)e).key;
                Object value = ((Entry)e).getValue();
                h += Long.hashCode(key) ^ (value == null ? 0 : value.hashCode());
            }
        }
        return h;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HeapTrackingConcurrentLongObjectHashMap)) {
            return false;
        }
        HeapTrackingConcurrentLongObjectHashMap m = (HeapTrackingConcurrentLongObjectHashMap)o;
        if (m.size() != this.size()) {
            return false;
        }
        EntryIterator iterator = new EntryIterator(this);
        while (iterator.hasNext()) {
            Object e = iterator.next();
            long key = ((Entry)e).key;
            Object value = ((Entry)e).getValue();
            if (!(value == null ? m.get(key) != null || !m.containsKey(key) : !value.equals(m.get(key)))) continue;
            return false;
        }
        return true;
    }

    @Override
    public void close() {
        this.memoryTracker.releaseHeap(SHALLOW_SIZE_THIS);
        this.releaseHeap();
    }

    private static final class Entry<V>
    implements Map.Entry<Long, V>,
    AbstractHeapTrackingConcurrentHash.Wrapper<Entry<V>> {
        private final long key;
        private final V value;
        private final Entry<V> next;

        private Entry(long key, V value) {
            this.key = key;
            this.value = value;
            this.next = null;
        }

        private Entry(long key, V value, Entry<V> next) {
            this.key = key;
            this.value = value;
            this.next = next;
        }

        @Override
        public Long getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            throw new RuntimeException("not implemented");
        }

        @Override
        public Entry<V> getNext() {
            return this.next;
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object k2 = e.getKey();
            if (!Objects.equals(this.key, k2)) {
                return false;
            }
            Object v2 = e.getValue();
            return Objects.equals(this.value, v2);
        }

        @Override
        public int hashCode() {
            return Long.hashCode(this.key) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public String toString() {
            return this.key + "=" + String.valueOf(this.value);
        }
    }

    private class KeyIterator
    extends LongHashIterator<Object>
    implements LongIterator {
        private KeyIterator(HeapTrackingConcurrentLongObjectHashMap heapTrackingConcurrentLongObjectHashMap) {
        }

        public long next() {
            return this.nextEntry().key;
        }
    }

    private class ValueIterator
    extends LongHashIterator<V>
    implements Iterator<V> {
        private ValueIterator(HeapTrackingConcurrentLongObjectHashMap heapTrackingConcurrentLongObjectHashMap) {
        }

        @Override
        public void remove() {
            this.removeByKeyValue();
        }

        @Override
        public V next() {
            return this.nextEntry().value;
        }
    }

    private class EntryIterator
    extends LongHashIterator<V>
    implements Iterator<Entry<V>> {
        private EntryIterator(HeapTrackingConcurrentLongObjectHashMap heapTrackingConcurrentLongObjectHashMap) {
        }

        @Override
        public void remove() {
            this.removeByKeyValue();
        }

        @Override
        public Entry<V> next() {
            return this.nextEntry();
        }
    }

    private abstract class LongHashIterator<E>
    extends AbstractHeapTrackingConcurrentHash.HashIterator<Entry<V>> {
        private LongHashIterator() {
        }

        final Entry<V> nextEntry() {
            Entry e = (Entry)this.next;
            if (e == null) {
                throw new NoSuchElementException();
            }
            this.next = e.getNext();
            if (this.next == null) {
                this.findNext();
            }
            this.current = e;
            return e;
        }

        protected boolean removeByKeyValue() {
            if (this.current == null) {
                throw new IllegalStateException();
            }
            long key = ((Entry)this.current).key;
            Object val = ((Entry)this.current).value;
            this.current = null;
            return HeapTrackingConcurrentLongObjectHashMap.this.remove(key, val);
        }
    }
}

