/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collection;

import java.util.Arrays;
import org.apache.commons.lang3.ArrayUtils;

public final class PrimitiveArrays {
    private PrimitiveArrays() {
    }

    public static int[] deduplicate(int[] values) {
        if (values.length < 2) {
            return values;
        }
        int lastValue = values[0];
        int uniqueIndex = 1;
        for (int i = 1; i < values.length; ++i) {
            int currentValue = values[i];
            if (currentValue == lastValue) continue;
            values[uniqueIndex] = currentValue;
            lastValue = currentValue;
            ++uniqueIndex;
        }
        return uniqueIndex < values.length ? Arrays.copyOf(values, uniqueIndex) : values;
    }

    public static int[] union(int[] lhs, int[] rhs) {
        if (lhs == null || rhs == null) {
            return lhs == null ? rhs : lhs;
        }
        assert (PrimitiveArrays.isSortedSet(lhs) && PrimitiveArrays.isSortedSet(rhs));
        if (lhs.length < rhs.length) {
            return PrimitiveArrays.union(rhs, lhs);
        }
        int[] merged = null;
        int m = 0;
        int l = 0;
        int r = 0;
        while (l <= lhs.length && r < rhs.length) {
            while (l < lhs.length && lhs[l] < rhs[r]) {
                if (merged != null) {
                    merged[m++] = lhs[l];
                }
                ++l;
            }
            if (l == lhs.length) {
                if (merged == null) {
                    merged = Arrays.copyOf(lhs, lhs.length + rhs.length - r);
                    m = l;
                }
                System.arraycopy(rhs, r, merged, m, rhs.length - r);
                m += rhs.length - r;
                break;
            }
            if (lhs[l] > rhs[r]) {
                if (merged == null) {
                    merged = Arrays.copyOf(lhs, lhs.length + rhs.length - r);
                    m = l;
                }
                merged[m++] = rhs[r++];
                continue;
            }
            if (merged != null) {
                merged[m++] = lhs[l];
            }
            ++l;
            ++r;
        }
        if (merged == null) {
            return lhs;
        }
        if (l < lhs.length) {
            System.arraycopy(lhs, l, merged, m, lhs.length - l);
            m += lhs.length - l;
        }
        if (m < merged.length) {
            merged = Arrays.copyOf(merged, m);
        }
        return merged;
    }

    public static int[] intersect(int[] left, int[] right) {
        if (left == null || right == null) {
            return ArrayUtils.EMPTY_INT_ARRAY;
        }
        assert (PrimitiveArrays.isSortedSet(left) && PrimitiveArrays.isSortedSet(right));
        long uniqueCounts = PrimitiveArrays.countUnique(left, right);
        if (uniqueCounts == 0L) {
            return right;
        }
        if (PrimitiveArrays.right(uniqueCounts) == right.length || PrimitiveArrays.left(uniqueCounts) == left.length) {
            return ArrayUtils.EMPTY_INT_ARRAY;
        }
        int[] intersect = new int[left.length - PrimitiveArrays.left(uniqueCounts)];
        int cursor = 0;
        int l = 0;
        int r = 0;
        while (l < left.length && r < right.length) {
            if (left[l] == right[r]) {
                intersect[cursor++] = left[l];
                ++l;
                ++r;
                continue;
            }
            if (left[l] < right[r]) {
                ++l;
                continue;
            }
            ++r;
        }
        assert (cursor == intersect.length);
        return intersect;
    }

    public static int[] symmetricDifference(int[] left, int[] right) {
        if (left == null || right == null) {
            return left == null ? right : left;
        }
        assert (PrimitiveArrays.isSortedSet(left) && PrimitiveArrays.isSortedSet(right));
        long uniqueCounts = PrimitiveArrays.countUnique(left, right);
        if (uniqueCounts == 0L) {
            return ArrayUtils.EMPTY_INT_ARRAY;
        }
        int[] difference = new int[PrimitiveArrays.left(uniqueCounts) + PrimitiveArrays.right(uniqueCounts)];
        int cursor = 0;
        int l = 0;
        int r = 0;
        while (l < left.length && r < right.length) {
            if (left[l] == right[r]) {
                ++l;
                ++r;
                continue;
            }
            if (left[l] < right[r]) {
                difference[cursor++] = left[l];
                ++l;
                continue;
            }
            difference[cursor++] = right[r];
            ++r;
        }
        while (l < left.length) {
            difference[cursor++] = left[l];
            ++l;
        }
        while (r < right.length) {
            difference[cursor++] = right[r];
            ++r;
        }
        assert (cursor == difference.length);
        return difference;
    }

    public static RemovalsAndAdditions toRemovalsAndAdditions(int[] before, int[] after) {
        boolean beforeIsEmpty = PrimitiveArrays.nullOrEmpty(before);
        boolean afterIsEmpty = PrimitiveArrays.nullOrEmpty(after);
        if (beforeIsEmpty || afterIsEmpty) {
            return new RemovalsAndAdditions(beforeIsEmpty ? ArrayUtils.EMPTY_INT_ARRAY : before, afterIsEmpty ? ArrayUtils.EMPTY_INT_ARRAY : after);
        }
        assert (PrimitiveArrays.isSortedSet(before) && PrimitiveArrays.isSortedSet(after));
        long uniqueCounts = PrimitiveArrays.countUnique(before, after);
        if (uniqueCounts == 0L) {
            return RemovalsAndAdditions.NO_CHANGES;
        }
        int leftCount = PrimitiveArrays.left(uniqueCounts);
        int[] removals = leftCount == 0 ? ArrayUtils.EMPTY_INT_ARRAY : new int[leftCount];
        int rightCount = PrimitiveArrays.right(uniqueCounts);
        int[] additions = rightCount == 0 ? ArrayUtils.EMPTY_INT_ARRAY : new int[rightCount];
        int removalsCursor = 0;
        int additionsCursor = 0;
        int l = 0;
        int r = 0;
        while (l < before.length && r < after.length) {
            if (before[l] == after[r]) {
                ++l;
                ++r;
                continue;
            }
            if (before[l] < after[r]) {
                removals[removalsCursor++] = before[l];
                ++l;
                continue;
            }
            additions[additionsCursor++] = after[r];
            ++r;
        }
        while (l < before.length) {
            removals[removalsCursor++] = before[l];
            ++l;
        }
        while (r < after.length) {
            additions[additionsCursor++] = after[r];
            ++r;
        }
        assert (removalsCursor == removals.length);
        assert (additionsCursor == additions.length);
        return new RemovalsAndAdditions(removals, additions);
    }

    private static boolean nullOrEmpty(int[] array) {
        return array == null || array.length == 0;
    }

    static long countUnique(int[] left, int[] right) {
        int l = 0;
        int r = 0;
        int uniqueInLeft = 0;
        int uniqueInRight = 0;
        while (l < left.length && r < right.length) {
            if (left[l] == right[r]) {
                ++l;
                ++r;
                continue;
            }
            if (left[l] < right[r]) {
                ++uniqueInLeft;
                ++l;
                continue;
            }
            ++uniqueInRight;
            ++r;
        }
        return PrimitiveArrays.intPair(uniqueInLeft += left.length - l, uniqueInRight += right.length - r);
    }

    public static boolean contains(int[] list, int value) {
        for (int x : list) {
            if (value != x) continue;
            return true;
        }
        return false;
    }

    public static int[] subtract(int[] sortedItems, int ... sortedItemsToRemove) {
        if (sortedItems == null) {
            return null;
        }
        if (sortedItemsToRemove == null) {
            return sortedItems;
        }
        int[] result = new int[sortedItems.length];
        int i1 = 0;
        int ri = 0;
        int i2 = 0;
        while (i1 < sortedItems.length && i2 < sortedItemsToRemove.length) {
            int item = sortedItems[i1];
            int itemToRemove = sortedItemsToRemove[i2];
            if (item < itemToRemove) {
                result[ri++] = item;
                ++i1;
                continue;
            }
            if (item == itemToRemove) {
                ++i1;
            }
            ++i2;
        }
        int remaining = sortedItems.length - i1;
        if (remaining > 0) {
            System.arraycopy(sortedItems, i1, result, ri, remaining);
            ri += remaining;
        }
        return ri < result.length ? Arrays.copyOf(result, ri) : result;
    }

    private static long intPair(int left, int right) {
        return (long)left << 32 | (long)right;
    }

    private static int left(long pair) {
        return (int)(pair >> 32);
    }

    private static int right(long pair) {
        return (int)(pair & 0xFFFFFFFFL);
    }

    private static boolean isSortedSet(int[] set) {
        for (int i = 0; i < set.length - 1; ++i) {
            assert (set[i] < set[i + 1]) : "Array is not a sorted set: has " + set[i] + " before " + set[i + 1];
        }
        return true;
    }

    public record RemovalsAndAdditions(int[] removals, int[] additions) {
        public static final RemovalsAndAdditions NO_CHANGES = new RemovalsAndAdditions(ArrayUtils.EMPTY_INT_ARRAY, ArrayUtils.EMPTY_INT_ARRAY);

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object o) {
            int[] otherRemovals;
            int[] nArray;
            if (!(o instanceof RemovalsAndAdditions)) return false;
            RemovalsAndAdditions removalsAndAdditions = (RemovalsAndAdditions)o;
            try {
                otherRemovals = nArray = removalsAndAdditions.removals();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            int[] otherAdditions = nArray = removalsAndAdditions.additions();
            if (!Arrays.equals(this.removals, otherRemovals)) return false;
            if (!Arrays.equals(this.additions, otherAdditions)) return false;
            return true;
        }

        @Override
        public String toString() {
            return "AdditionsAndRemovals{additions=" + Arrays.toString(this.additions) + ", removals=" + Arrays.toString(this.removals) + "}";
        }
    }
}

