/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collection;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.neo4j.collection.ResourceRawIterator;
import org.neo4j.internal.helpers.collection.Iterators;

public interface RawIterator<T, EXCEPTION extends Exception> {
    public boolean hasNext() throws EXCEPTION;

    public T next() throws EXCEPTION;

    default public void remove() {
        throw new UnsupportedOperationException();
    }

    public static <T, EXCEPTION extends Exception> ResourceRawIterator<T, EXCEPTION> empty() {
        return ResourceRawIterator.empty();
    }

    public static <T, EX extends Exception> RawIterator<T, EX> of(final T ... values) {
        return new RawIterator<T, EX>(){
            private int position;

            @Override
            public boolean hasNext() {
                return this.position < values.length;
            }

            @Override
            public T next() throws Exception {
                if (this.hasNext()) {
                    return values[this.position++];
                }
                throw new NoSuchElementException();
            }
        };
    }

    public static <T, EX extends Exception> RawIterator<T, EX> wrap(Iterator<T> iterator) {
        return Iterators.asRawIterator(iterator);
    }
}

