/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collection.diffset;

import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Predicate;

public interface DiffSets<T> {
    public boolean isAdded(T var1);

    public boolean isRemoved(T var1);

    public Set<T> getAdded();

    public Set<T> getRemoved();

    public boolean isEmpty();

    public Iterator<T> apply(Iterator<? extends T> var1);

    public DiffSets<T> filterAdded(Predicate<T> var1);

    public static final class Empty<T>
    implements DiffSets<T> {
        private static final DiffSets<?> INSTANCE = new Empty();

        public static <T> DiffSets<T> instance() {
            return INSTANCE;
        }

        public static <T> DiffSets<T> ifNull(DiffSets<T> diffSets) {
            return diffSets == null ? INSTANCE : diffSets;
        }

        private Empty() {
        }

        @Override
        public boolean isAdded(T elem) {
            return false;
        }

        @Override
        public boolean isRemoved(T elem) {
            return false;
        }

        @Override
        public Set<T> getAdded() {
            return Collections.emptySet();
        }

        @Override
        public Set<T> getRemoved() {
            return Collections.emptySet();
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public Iterator<T> apply(Iterator<? extends T> source) {
            return source;
        }

        @Override
        public DiffSets<T> filterAdded(Predicate<T> addedFilter) {
            return this;
        }
    }
}

