/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.helpers.collection;

public class LongRange {
    private final long from;
    private final long to;

    public static LongRange range(long from, long to) {
        return new LongRange(from, to);
    }

    public static void assertIsRange(long from, long to) {
        if (from < 0L) {
            throw new IllegalArgumentException("Range cannot start from negative value. Got: " + from);
        }
        if (to < from) {
            throw new IllegalArgumentException(String.format("Not a valid range. RequiredTxId[%d] must be higher or equal to startTxId[%d].", to, from));
        }
    }

    private LongRange(long from, long to) {
        LongRange.assertIsRange(from, to);
        this.from = from;
        this.to = to;
    }

    public boolean isWithinRange(long val) {
        return val >= this.from && val <= this.to;
    }

    public boolean isWithinRangeExclusiveTo(long val) {
        return val >= this.from && val < this.to;
    }

    public String toString() {
        return "LongRange{from=" + this.from + ", to=" + this.to + "}";
    }

    public long from() {
        return this.from;
    }

    public long to() {
        return this.to;
    }
}

