/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collection.pool;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.neo4j.collection.pool.Pool;

public class MarshlandPool<T>
implements Pool<T> {
    private final Pool<T> delegate;
    private final Set<LocalSlotReference<T>> slotReferences = ConcurrentHashMap.newKeySet();
    private final ReferenceQueue<LocalSlot<T>> objectsFromDeadThreads = new ReferenceQueue();
    private final ThreadLocal<LocalSlot<T>> puddle = ThreadLocal.withInitial(() -> {
        LocalSlot<T> localSlot = new LocalSlot<T>(this.objectsFromDeadThreads);
        this.slotReferences.add(localSlot.slotWeakReference);
        return localSlot;
    });

    public MarshlandPool(Pool<T> delegatePool) {
        this.delegate = delegatePool;
    }

    @Override
    public T acquire() {
        LocalSlot<Object> localSlot = this.puddle.get();
        Object obj = localSlot.localSlotObject;
        if (obj != null) {
            localSlot.set(null);
            return obj;
        }
        LocalSlotReference slotReference = (LocalSlotReference)this.objectsFromDeadThreads.poll();
        if (slotReference != null && slotReference.localSlotReferenceObject != null) {
            this.slotReferences.remove(slotReference);
            return slotReference.localSlotReferenceObject;
        }
        return this.delegate.acquire();
    }

    @Override
    public void release(T obj) {
        LocalSlot<T> localSlot = this.puddle.get();
        if (localSlot.localSlotObject == null) {
            localSlot.set(obj);
        } else {
            this.delegate.release(obj);
        }
    }

    @Override
    public void close() {
        LocalSlotReference reference;
        for (LocalSlotReference<T> slotReference : this.slotReferences) {
            Object obj;
            LocalSlot slot = (LocalSlot)slotReference.get();
            if (slot == null || (obj = slot.localSlotObject) == null) continue;
            slot.set(null);
            this.delegate.release(obj);
        }
        while ((reference = (LocalSlotReference)this.objectsFromDeadThreads.poll()) != null) {
            Object obj = reference.localSlotReferenceObject;
            if (obj == null) continue;
            this.delegate.release(obj);
        }
    }

    private static final class LocalSlotReference<T>
    extends WeakReference<LocalSlot<T>> {
        private T localSlotReferenceObject;

        private LocalSlotReference(LocalSlot<T> referent, ReferenceQueue<? super LocalSlot<T>> q) {
            super(referent, q);
        }
    }

    private static final class LocalSlot<T> {
        private T localSlotObject;
        private final LocalSlotReference<T> slotWeakReference;

        private LocalSlot(ReferenceQueue<LocalSlot<T>> referenceQueue) {
            this.slotWeakReference = new LocalSlotReference<T>(this, referenceQueue);
        }

        public void set(T obj) {
            this.slotWeakReference.localSlotReferenceObject = obj;
            this.localSlotObject = obj;
        }
    }
}

