/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collection.trackable;

import org.eclipse.collections.api.map.primitive.MutableIntObjectMap;
import org.neo4j.collection.trackable.HeapTrackingArrayList;
import org.neo4j.collection.trackable.HeapTrackingIntObjectHashMap;
import org.neo4j.collection.trackable.HeapTrackingLongArrayList;
import org.neo4j.collection.trackable.HeapTrackingLongHashSet;
import org.neo4j.collection.trackable.HeapTrackingLongIntHashMap;
import org.neo4j.collection.trackable.HeapTrackingLongObjectHashMap;
import org.neo4j.collection.trackable.HeapTrackingLongStack;
import org.neo4j.collection.trackable.HeapTrackingStack;
import org.neo4j.collection.trackable.HeapTrackingUnifiedMap;
import org.neo4j.collection.trackable.HeapTrackingUnifiedSet;
import org.neo4j.memory.MemoryTracker;

public final class HeapTrackingCollections {
    private HeapTrackingCollections() {
    }

    public static <V> MutableIntObjectMap<V> newIntObjectHashMap(MemoryTracker memoryTracker) {
        return HeapTrackingIntObjectHashMap.createIntObjectHashMap(memoryTracker);
    }

    public static HeapTrackingLongHashSet newLongSet(MemoryTracker memoryTracker) {
        return HeapTrackingLongHashSet.createLongHashSet(memoryTracker);
    }

    public static HeapTrackingLongHashSet newLongSet(MemoryTracker memoryTracker, int initialCapacity) {
        return HeapTrackingLongHashSet.createLongHashSet(memoryTracker, initialCapacity);
    }

    public static <V> HeapTrackingLongObjectHashMap<V> newLongObjectMap(MemoryTracker memoryTracker) {
        return HeapTrackingLongObjectHashMap.createLongObjectHashMap(memoryTracker);
    }

    public static HeapTrackingLongIntHashMap newLongIntMap(MemoryTracker memoryTracker) {
        return HeapTrackingLongIntHashMap.createLongIntHashMap(memoryTracker);
    }

    public static <K, V> HeapTrackingUnifiedMap<K, V> newMap(MemoryTracker memoryTracker) {
        return HeapTrackingUnifiedMap.createUnifiedMap(memoryTracker);
    }

    public static <T> HeapTrackingUnifiedSet<T> newSet(MemoryTracker memoryTracker) {
        return HeapTrackingUnifiedSet.createUnifiedSet(memoryTracker);
    }

    public static <T> HeapTrackingArrayList<T> newArrayList(int initialSize, MemoryTracker memoryTracker) {
        return HeapTrackingArrayList.newArrayList(initialSize, memoryTracker);
    }

    public static <T> HeapTrackingArrayList<T> newArrayList(MemoryTracker memoryTracker) {
        return HeapTrackingArrayList.newArrayList(memoryTracker);
    }

    public static HeapTrackingLongStack newLongStack(MemoryTracker memoryTracker) {
        return new HeapTrackingLongStack(HeapTrackingLongArrayList.newLongArrayList(memoryTracker));
    }

    public static <T> HeapTrackingStack<T> newStack(MemoryTracker memoryTracker) {
        return new HeapTrackingStack(HeapTrackingArrayList.newArrayList(memoryTracker));
    }
}

