/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collection.trackable;

import java.util.Objects;
import org.eclipse.collections.impl.map.mutable.primitive.LongObjectHashMap;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.util.VisibleForTesting;

public class HeapTrackingLongObjectHashMap<V>
extends LongObjectHashMap<V>
implements AutoCloseable {
    private static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(HeapTrackingLongObjectHashMap.class);
    protected static final int DEFAULT_INITIAL_CAPACITY = 16;
    protected final MemoryTracker memoryTracker;
    private int trackedCapacity;

    @VisibleForTesting
    public static <V> HeapTrackingLongObjectHashMap<V> createLongObjectHashMap(MemoryTracker memoryTracker) {
        memoryTracker.allocateHeap(SHALLOW_SIZE + HeapTrackingLongObjectHashMap.arraysHeapSize(16));
        return new HeapTrackingLongObjectHashMap<V>(memoryTracker, 16);
    }

    public HeapTrackingLongObjectHashMap(MemoryTracker memoryTracker, int trackedCapacity) {
        this.memoryTracker = Objects.requireNonNull(memoryTracker);
        this.trackedCapacity = trackedCapacity;
    }

    protected void allocateTable(int sizeToAllocate) {
        if (this.memoryTracker != null) {
            this.memoryTracker.allocateHeap(HeapTrackingLongObjectHashMap.arraysHeapSize(sizeToAllocate));
            this.memoryTracker.releaseHeap(HeapTrackingLongObjectHashMap.arraysHeapSize(this.trackedCapacity));
            this.trackedCapacity = sizeToAllocate;
        }
        super.allocateTable(sizeToAllocate);
    }

    @Override
    public void close() {
        this.memoryTracker.releaseHeap(HeapTrackingLongObjectHashMap.arraysHeapSize(this.trackedCapacity) + SHALLOW_SIZE);
    }

    @VisibleForTesting
    public static long arraysHeapSize(int arrayLength) {
        long keyArray = HeapEstimator.alignObjectSize((long)((long)HeapEstimator.ARRAY_HEADER_BYTES + (long)arrayLength * 8L));
        long valueArray = HeapEstimator.alignObjectSize((long)((long)HeapEstimator.ARRAY_HEADER_BYTES + (long)arrayLength * (long)HeapEstimator.OBJECT_REFERENCE_BYTES));
        return keyArray + valueArray;
    }
}

