/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.helpers.collection;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.RemovalListener;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import org.neo4j.util.Preconditions;

public class LfuCache<K, E> {
    private final String name;
    private final int maxSize;
    private final Cache<K, E> cache;

    public LfuCache(String name, int maxSize) {
        this(name, maxSize, null);
    }

    public LfuCache(String name, int maxSize, BiConsumer<K, E> removalListener) {
        this.name = Objects.requireNonNull(name);
        this.maxSize = Preconditions.requirePositive((int)maxSize);
        Caffeine caffeineBuilder = Caffeine.newBuilder().executor(Runnable::run).maximumSize((long)maxSize);
        if (removalListener != null) {
            RemovalListener listener = (k, v, c) -> removalListener.accept(k, v);
            caffeineBuilder.removalListener(listener);
        }
        this.cache = caffeineBuilder.build();
    }

    public String getName() {
        return this.name;
    }

    public int maxSize() {
        return this.maxSize;
    }

    public void put(K key, E element) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(element);
        this.cache.put(key, element);
    }

    public E get(K key) {
        Objects.requireNonNull(key);
        return (E)this.cache.getIfPresent(key);
    }

    public void clear() {
        this.cache.invalidateAll();
    }

    public int size() {
        return this.cache.asMap().size();
    }

    public Set<K> keySet() {
        return this.cache.asMap().keySet();
    }
}

